/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.archetype.MavenArchetype;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypePage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArchetypeParametersPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardArtifactPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardLocationPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWorkspaceAssigner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class MavenProjectWizard
extends AbstractMavenProjectWizard
implements INewWizard {
    protected MavenProjectWizardLocationPage locationPage;
    protected MavenProjectWizardArchetypePage archetypePage;
    protected MavenProjectWizardArtifactPage artifactPage;
    protected MavenProjectWizardArchetypeParametersPage parametersPage;
    protected Button simpleProject;

    public MavenProjectWizard() {
        this.setWindowTitle(Messages.wizardProjectTitle);
        this.setDefaultPageImageDescriptor(MavenImages.WIZ_NEW_MAVEN_PROJECT);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.locationPage = new MavenProjectWizardLocationPage(this.importConfiguration, Messages.wizardProjectPageProjectTitle, Messages.wizardProjectPageProjectDescription, this.workingSets){

            @Override
            protected void createAdditionalControls(Composite container) {
                MavenProjectWizard.this.simpleProject = new Button(container, 32);
                MavenProjectWizard.this.simpleProject.setText(Messages.wizardProjectPageProjectSimpleProject);
                MavenProjectWizard.this.simpleProject.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
                MavenProjectWizard.this.simpleProject.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.validate()));
                Label label = new Label(container, 0);
                GridData labelData = new GridData(4, 128, false, false, 3, 1);
                labelData.heightHint = 10;
                label.setLayoutData((Object)labelData);
            }

            public IWizardPage getNextPage() {
                return MavenProjectWizard.this.getPage(MavenProjectWizard.this.simpleProject.getSelection() ? "MavenProjectWizardArtifactPage" : "MavenProjectWizardArchetypePage");
            }
        };
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation(this.selection));
        this.archetypePage = new MavenProjectWizardArchetypePage(this.importConfiguration);
        this.parametersPage = new MavenProjectWizardArchetypeParametersPage(this.importConfiguration);
        this.artifactPage = new MavenProjectWizardArtifactPage(this.importConfiguration);
        this.addPage((IWizardPage)this.locationPage);
        this.addPage((IWizardPage)this.archetypePage);
        this.addPage((IWizardPage)this.parametersPage);
        this.addPage((IWizardPage)this.artifactPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.simpleProject.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean isSimpleproject = this.simpleProject.getSelection();
            this.archetypePage.setUsed(!isSimpleproject);
            this.parametersPage.setUsed(!isSimpleproject);
            this.artifactPage.setUsed(isSimpleproject);
            this.getContainer().updateButtons();
        }));
        this.archetypePage.addArchetypeSelectionListener(selectionchangedevent -> {
            this.parametersPage.setArchetype(this.archetypePage.getArchetype());
            this.getContainer().updateButtons();
        });
    }

    public Model getModel() {
        if (this.simpleProject.getSelection()) {
            return this.artifactPage.getModel();
        }
        return this.parametersPage.getModel();
    }

    public boolean performFinish() {
        AbstractCreateMavenProjectJob job;
        final Model model = this.getModel();
        final String projectName = ProjectConfigurationManager.getProjectName((ProjectImportConfiguration)this.importConfiguration, (Model)model);
        IStatus nameStatus = MavenProjectWizard.validateProjectName(this.importConfiguration, model);
        if (!nameStatus.isOK()) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)nameStatus.getMessage());
            return false;
        }
        final IPath location = this.locationPage.isInWorkspace() ? null : this.locationPage.getLocationPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject project = root.getProject(projectName);
        boolean pomExists = (this.locationPage.isInWorkspace() ? root.getLocation().append(project.getName()) : location).append("pom.xml").toFile().exists();
        if (pomExists) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)Messages.wizardProjectErrorPomAlreadyExists);
            return false;
        }
        if (this.simpleProject.getSelection()) {
            final List<String> folders = this.artifactPage.getFolders();
            job = new AbstractCreateMavenProjectJob(NLS.bind((String)Messages.wizardProjectJobCreatingProject, (Object)projectName)){

                @Override
                protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                    MavenPlugin.getProjectConfigurationManager().createSimpleProject(project, location, model, folders, MavenProjectWizard.this.importConfiguration, (IProjectCreationListener)new MavenProjectWorkspaceAssigner(MavenProjectWizard.this.workingSets), monitor);
                    return Arrays.asList(project);
                }
            };
        } else {
            final Archetype archetype = this.archetypePage.getArchetype();
            final String groupId = model.getGroupId();
            final String artifactId = model.getArtifactId();
            final String version = model.getVersion();
            final String javaPackage = this.parametersPage.getJavaPackage();
            final Map<String, String> properties = this.parametersPage.getProperties();
            final boolean interactive = this.parametersPage.isInteractive();
            job = new AbstractCreateMavenProjectJob(NLS.bind((String)Messages.wizardProjectJobCreating, (Object)archetype.getArtifactId())){

                @Override
                protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                    Collection<MavenProjectInfo> projects = M2EUIPluginActivator.getDefault().getArchetypePlugin().getGenerator().createArchetypeProjects(location, new MavenArchetype(archetype), groupId, artifactId, version, javaPackage, properties, interactive, monitor);
                    return MavenPlugin.getProjectConfigurationManager().importProjects(projects, MavenProjectWizard.this.importConfiguration, (IProjectCreationListener)new MavenProjectWorkspaceAssigner(MavenProjectWizard.this.workingSets), monitor).stream().filter(r -> r.getProject() != null && r.getProject().exists()).map(IMavenProjectImportResult::getProject).toList();
                }
            };
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result = event.getResult();
                if (!result.isOK()) {
                    Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)MavenProjectWizard.this.getShell(), (String)NLS.bind((String)Messages.wizardProjectJobFailed, (Object)projectName), (String)result.getMessage()));
                }
                MappingDiscoveryJob discoveryJob = new MappingDiscoveryJob(job.getCreatedProjects(), true);
                discoveryJob.schedule();
            }
        });
        job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
        job.schedule();
        return true;
    }

    static IStatus validateProjectName(ProjectImportConfiguration configuration, Model model) {
        String projectName = ProjectConfigurationManager.getProjectName((ProjectImportConfiguration)configuration, (Model)model);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        if (workspace.getRoot().getProject(projectName).exists()) {
            return Status.error((String)NLS.bind((String)org.eclipse.m2e.core.internal.Messages.importProjectExists, (Object)projectName));
        }
        return Status.OK_STATUS;
    }
}

