/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerDescriptor;

public class CompletionProposalContentTypeContext {
    private final String fContentTypeID;
    private Map fPartitionTypesToDescriptors;

    public CompletionProposalContentTypeContext(String contentTypeID) {
        this.fContentTypeID = contentTypeID;
        this.fPartitionTypesToDescriptors = new HashMap();
    }

    public void putDescriptor(String partitionTypeID, CompletionProposalComputerDescriptor descriptor) {
        HashSet<CompletionProposalComputerDescriptor> descriptors = (HashSet<CompletionProposalComputerDescriptor>)this.fPartitionTypesToDescriptors.get(partitionTypeID);
        if (descriptors != null) {
            descriptors.add(descriptor);
        } else {
            descriptors = new HashSet<CompletionProposalComputerDescriptor>();
            descriptors.add(descriptor);
            this.fPartitionTypesToDescriptors.put(partitionTypeID, descriptors);
        }
    }

    public Set getDescriptors() {
        HashSet allDescriptors = new HashSet();
        Collection descriptorSets = this.fPartitionTypesToDescriptors.values();
        for (Set descriptorSet : descriptorSets) {
            allDescriptors.addAll(descriptorSet);
        }
        return Collections.unmodifiableSet(allDescriptors);
    }

    public Set getDescriptors(String partitionTypeID) {
        Set descriptors = (Set)this.fPartitionTypesToDescriptors.get(partitionTypeID);
        return descriptors != null ? Collections.unmodifiableSet(descriptors) : Collections.EMPTY_SET;
    }

    public String getContentTypeID() {
        return this.fContentTypeID;
    }

    public int hashCode() {
        return this.fContentTypeID.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof CompletionProposalContentTypeContext) {
            equal = this.fContentTypeID.equals(((CompletionProposalContentTypeContext)obj).fContentTypeID);
        }
        return equal;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.fContentTypeID);
        Set partitions = this.fPartitionTypesToDescriptors.keySet();
        for (String partitionType : partitions) {
            buff.append("\n\t" + partitionType);
            List descriptors = (List)this.fPartitionTypesToDescriptors.get(partitionType);
            int i = 0;
            while (i < descriptors.size()) {
                buff.append("\n\t\t" + descriptors.get(i).toString());
                ++i;
            }
        }
        return buff.toString();
    }
}

