/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectTask;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;

public final class ProjectTaskNode
implements TaskNode {
    private final ProjectNode parentProjectNode;
    private final ProjectTask projectTask;

    public ProjectTaskNode(ProjectNode parentProjectNode, ProjectTask projectTask) {
        this.parentProjectNode = (ProjectNode)Preconditions.checkNotNull((Object)parentProjectNode);
        this.projectTask = (ProjectTask)Preconditions.checkNotNull((Object)projectTask);
    }

    @Override
    public ProjectNode getParentProjectNode() {
        return this.parentProjectNode;
    }

    @Override
    public String getName() {
        return this.projectTask.getName();
    }

    @Override
    public TaskNode.TaskNodeType getType() {
        return TaskNode.TaskNodeType.PROJECT_TASK_NODE;
    }

    @Override
    public boolean isPublic() {
        return this.projectTask.isPublic();
    }

    public String toString() {
        return this.projectTask.getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectTaskNode that = (ProjectTaskNode)other;
        return Objects.equal((Object)this.parentProjectNode, (Object)that.parentProjectNode) && Objects.equal((Object)this.projectTask, (Object)that.projectTask);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parentProjectNode, this.projectTask});
    }

    public String getDescription() {
        return this.projectTask.getDescription();
    }

    public String getPath() {
        if (this.parentProjectNode.getBuildNode().isIncludedBuild()) {
            return ":" + this.parentProjectNode.getBuildNode().getIncludedBuildName() + this.projectTask.getPath().getPath();
        }
        return this.projectTask.getPath().getPath();
    }
}

