/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.ProposalPosition;

class CompletionSnippetParser {
    private final IDocument document;
    private final String snippetText;
    private final int insertionOffset;
    private final LinkedHashMap<String, List<LinkedPosition>> linkedPositions = new LinkedHashMap();
    private final Function<String, String> getVariableValue;
    private int snippetOffset = 0;
    private int snippetToDocumentOffset = 0;
    private boolean dontAddLinkedPositions = false;

    public CompletionSnippetParser(IDocument document, String snippetText, int insertionOffset, Function<String, String> getVariableValue) {
        this.document = document;
        this.snippetText = snippetText;
        this.insertionOffset = insertionOffset;
        this.getVariableValue = getVariableValue;
    }

    public String parse() {
        StringBuilder insertTextBuilder = new StringBuilder(this.snippetText.length());
        while (this.hasRemaining()) {
            char current = this.readChar();
            switch (current) {
                default: {
                    insertTextBuilder.append(current);
                    break;
                }
                case '\\': {
                    if (!this.hasRemaining()) {
                        insertTextBuilder.append(current);
                        break;
                    }
                    insertTextBuilder.append(this.readChar());
                    ++this.snippetToDocumentOffset;
                    break;
                }
                case '$': {
                    int _snippetOffset = this.snippetOffset;
                    int _snippetToDocumentOffset = this.snippetToDocumentOffset;
                    try {
                        String value = this.parseDollarExpression();
                        insertTextBuilder.append(value);
                        break;
                    }
                    catch (DollarExpressionParseException e) {
                        this.snippetOffset = _snippetOffset;
                        this.snippetToDocumentOffset = _snippetToDocumentOffset;
                        insertTextBuilder.append('$');
                    }
                }
            }
        }
        return insertTextBuilder.toString();
    }

    public Map<String, List<LinkedPosition>> getLinkedPositions() {
        return this.linkedPositions;
    }

    private String parseDollarExpression() throws DollarExpressionParseException {
        if (!this.hasRemaining()) {
            throw new DollarExpressionParseException();
        }
        char firstChar = this.peekChar();
        if (Character.isDigit(firstChar)) {
            String key = this.readNumberKey();
            this.snippetToDocumentOffset += key.length() + 1;
            LinkedPosition position = new LinkedPosition(this.document, this.insertionOffset + this.snippetOffset - this.snippetToDocumentOffset, 0);
            this.addLinkedPosition(key, position);
            return "";
        }
        if (this.isCharacterForVariableName(firstChar)) {
            String key = this.readVariableKey();
            String value = this.getVariableValue.apply(key);
            this.snippetToDocumentOffset += key.length() + 1 - value.length();
            return value;
        }
        if (firstChar == '{') {
            return this.parseDollarExpressionInBrackets();
        }
        throw new DollarExpressionParseException();
    }

    private String parseDollarExpressionInBrackets() throws DollarExpressionParseException {
        if (this.readChar() != '{') {
            throw new IllegalStateException();
        }
        if (!this.hasRemaining()) {
            throw new DollarExpressionParseException();
        }
        char firstKeyChar = this.peekChar();
        if (Character.isDigit(firstKeyChar)) {
            return this.parseTabStopInBrackets();
        }
        if (this.isCharacterForVariableName(firstKeyChar)) {
            return this.parseVariableExpressionInBrackets();
        }
        throw new DollarExpressionParseException();
    }

    private String parseVariableExpressionInBrackets() throws DollarExpressionParseException {
        int dollarOffset = this.snippetOffset - 2;
        String key = this.readVariableKey();
        if (!this.hasRemaining()) {
            throw new DollarExpressionParseException();
        }
        char postKeyChar = this.readChar();
        String defaultValue = "";
        switch (postKeyChar) {
            case '}': {
                break;
            }
            case ':': {
                defaultValue = this.readTextValue();
                break;
            }
            case '/': {
                this.readTextValue();
                break;
            }
            default: {
                throw new DollarExpressionParseException();
            }
        }
        String value = this.getVariableValue.apply(key);
        if (value.isEmpty()) {
            value = defaultValue;
        }
        this.snippetToDocumentOffset += this.snippetOffset - dollarOffset - value.length();
        return value;
    }

    private String parseTabStopInBrackets() throws DollarExpressionParseException {
        LinkedPosition position;
        String defaultProposal;
        int dollarOffset = this.snippetOffset - 2;
        String key = this.readNumberKey();
        if (!this.hasRemaining()) {
            throw new DollarExpressionParseException();
        }
        char postKeyChar = this.readChar();
        List<Object> valueList = switch (postKeyChar) {
            case '}' -> Collections.emptyList();
            case ':' -> List.of(this.readTextValue());
            case '|' -> this.readChoiceValues();
            default -> throw new DollarExpressionParseException();
        };
        if (!valueList.isEmpty()) {
            defaultProposal = (String)valueList.get(0);
            int replacementOffset = this.insertionOffset + dollarOffset - this.snippetToDocumentOffset;
            ICompletionProposal[] proposals = (ICompletionProposal[])valueList.stream().map(string2 -> new CompletionProposal(string2, replacementOffset, defaultProposal.length(), replacementOffset + string2.length())).toArray(ICompletionProposal[]::new);
            position = new ProposalPosition(this.document, this.insertionOffset + dollarOffset - this.snippetToDocumentOffset, defaultProposal.length(), proposals);
        } else {
            defaultProposal = "";
            position = new LinkedPosition(this.document, this.insertionOffset + dollarOffset - this.snippetToDocumentOffset, 0);
        }
        this.addLinkedPosition(key, position);
        this.snippetToDocumentOffset += this.snippetOffset - dollarOffset - defaultProposal.length();
        return defaultProposal;
    }

    private List<String> readChoiceValues() throws DollarExpressionParseException {
        ArrayList<String> valueList = new ArrayList<String>();
        StringBuilder valueBuilder = new StringBuilder();
        block6: while (true) {
            if (!this.hasRemaining()) {
                throw new DollarExpressionParseException();
            }
            char c = this.readChar();
            switch (c) {
                default: {
                    valueBuilder.append(c);
                    continue block6;
                }
                case ',': {
                    valueList.add(valueBuilder.toString());
                    valueBuilder.setLength(0);
                    continue block6;
                }
                case '\\': {
                    if (!this.hasRemaining()) {
                        throw new DollarExpressionParseException();
                    }
                    valueBuilder.append(this.readChar());
                    continue block6;
                }
                case '}': {
                    throw new DollarExpressionParseException();
                }
                case '|': 
            }
            break;
        }
        if (!this.hasRemaining() || this.readChar() != '}') {
            throw new DollarExpressionParseException();
        }
        valueList.add(valueBuilder.toString());
        return valueList;
    }

    private String readTextValue() throws DollarExpressionParseException {
        StringBuilder valueBuilder = new StringBuilder();
        block9: while (true) {
            if (!this.hasRemaining()) {
                throw new DollarExpressionParseException();
            }
            char c = this.readChar();
            switch (c) {
                default: {
                    valueBuilder.append(c);
                    continue block9;
                }
                case '\\': {
                    if (!this.hasRemaining()) {
                        throw new DollarExpressionParseException();
                    }
                    valueBuilder.append(this.readChar());
                    continue block9;
                }
                case '$': {
                    int _snippetOffset = this.snippetOffset;
                    int _snippetToDocumentOffset = this.snippetToDocumentOffset;
                    boolean _dontAddLinkedPositions = this.dontAddLinkedPositions;
                    this.dontAddLinkedPositions = true;
                    try {
                        try {
                            String value = this.parseDollarExpression();
                            valueBuilder.append(value);
                        }
                        catch (DollarExpressionParseException e) {
                            this.snippetOffset = _snippetOffset;
                            valueBuilder.append('$');
                            this.dontAddLinkedPositions = _dontAddLinkedPositions;
                            this.snippetToDocumentOffset = _snippetToDocumentOffset;
                            continue block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.dontAddLinkedPositions = _dontAddLinkedPositions;
                        this.snippetToDocumentOffset = _snippetToDocumentOffset;
                        throw throwable;
                    }
                    this.dontAddLinkedPositions = _dontAddLinkedPositions;
                    this.snippetToDocumentOffset = _snippetToDocumentOffset;
                    continue block9;
                }
                case '}': 
            }
            break;
        }
        return valueBuilder.toString();
    }

    private void addLinkedPosition(String key, LinkedPosition position) {
        if (!this.dontAddLinkedPositions) {
            this.linkedPositions.computeIfAbsent(key, whatever -> new ArrayList()).add(position);
        }
    }

    private boolean hasRemaining() {
        return this.snippetOffset < this.snippetText.length();
    }

    private char peekChar() {
        return this.snippetText.charAt(this.snippetOffset);
    }

    private char readChar() {
        char retval = this.peekChar();
        ++this.snippetOffset;
        return retval;
    }

    private String readNumberKey() {
        StringBuilder keyBuilder = new StringBuilder();
        while (this.hasRemaining() && Character.isDigit(this.peekChar())) {
            keyBuilder.append(this.readChar());
        }
        return keyBuilder.toString();
    }

    private String readVariableKey() {
        StringBuilder keyBuilder = new StringBuilder();
        while (this.hasRemaining() && this.isCharacterForVariableName(this.peekChar())) {
            keyBuilder.append(this.readChar());
        }
        return keyBuilder.toString();
    }

    private boolean isCharacterForVariableName(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_';
    }

    private static final class DollarExpressionParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private DollarExpressionParseException() {
        }
    }
}

