/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types.xerces;

import java.util.LinkedList;
import java.util.List;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.internal.types.xerces.ComplexXercesTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.internal.types.xerces.SimpleXercesType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.xerces.SimpleXercesTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class XercesTypeDefinition
implements TypeDefinition {
    private final XSTypeDefinition xsTypeDefinition;
    private XercesTypeDefinition baseType = null;

    public XercesTypeDefinition(XSTypeDefinition typeDef) {
        if (typeDef == null) {
            throw new IllegalArgumentException("typeDef");
        }
        this.xsTypeDefinition = typeDef;
    }

    @Override
    public String getNamespace() {
        return this.xsTypeDefinition.getNamespace();
    }

    @Override
    public String getName() {
        return this.xsTypeDefinition.getName();
    }

    public boolean isComplexType() {
        return (this.xsTypeDefinition.getTypeCategory() & 8) != 0;
    }

    @Override
    public TypeDefinition getBaseType() {
        if (this.baseType == null && this.xsTypeDefinition.getBaseType() != null) {
            this.baseType = XercesTypeDefinition.createTypeDefinition(this.xsTypeDefinition.getBaseType());
        }
        return this.baseType;
    }

    @Override
    public boolean derivedFromType(TypeDefinition ancestorType, short derivationMethod) {
        if (ancestorType instanceof XercesTypeDefinition) {
            XercesTypeDefinition xercesType = (XercesTypeDefinition)ancestorType;
            return this.xsTypeDefinition.derivedFromType(xercesType.xsTypeDefinition, XercesTypeDefinition.mapFlags(derivationMethod));
        }
        return this.xsTypeDefinition.derivedFrom(ancestorType.getNamespace(), ancestorType.getName(), XercesTypeDefinition.mapFlags(derivationMethod));
    }

    @Override
    public boolean derivedFrom(String namespace, String name, short derivationMethod) {
        return this.xsTypeDefinition.derivedFrom(namespace, name, XercesTypeDefinition.mapFlags(derivationMethod));
    }

    private static short mapFlags(short modelFlags) {
        short xercesFlags = 0;
        if ((modelFlags & 0) != 0) {
            xercesFlags = (short)(xercesFlags | 0);
        }
        if ((modelFlags & 1) != 0) {
            xercesFlags = (short)(xercesFlags | 1);
        }
        if ((modelFlags & 2) != 0) {
            xercesFlags = (short)(xercesFlags | 2);
        }
        if ((modelFlags & 4) != 0) {
            xercesFlags = (short)(xercesFlags | 4);
        }
        if ((modelFlags & 8) != 0) {
            xercesFlags = (short)(xercesFlags | 8);
        }
        if ((modelFlags & 0x10) != 0) {
            xercesFlags = (short)(xercesFlags | 0x10);
        }
        return xercesFlags;
    }

    @Override
    public List getSimpleTypes(Attr attr) {
        PSVIAttrNSImpl psviAttr = (PSVIAttrNSImpl)attr;
        return this.mapList(psviAttr.getItemValueTypes());
    }

    @Override
    public List getSimpleTypes(Element element) {
        PSVIElementNSImpl psviElement = (PSVIElementNSImpl)element;
        return this.mapList(psviElement.getItemValueTypes());
    }

    private List mapList(ShortList valueTypes) {
        if (valueTypes == null) {
            return null;
        }
        LinkedList<Short> types = new LinkedList<Short>();
        int limit = valueTypes.getLength();
        int i = 0;
        while (i < limit) {
            types.add(valueTypes.item(i));
            ++i;
        }
        return types;
    }

    public static XercesTypeDefinition createTypeDefinition(XSTypeDefinition ad) {
        if (ad instanceof XSSimpleType) {
            return new SimpleXercesType((XSSimpleType)ad);
        }
        if (ad instanceof XSSimpleTypeDefinition) {
            return new SimpleXercesTypeDefinition((XSSimpleTypeDefinition)ad);
        }
        return new ComplexXercesTypeDefinition((XSComplexTypeDefinition)ad);
    }

    public static SimpleXercesTypeDefinition createTypeDefinition(XSSimpleTypeDefinition ad) {
        if (ad instanceof XSSimpleType) {
            return new SimpleXercesType((XSSimpleType)ad);
        }
        return new SimpleXercesTypeDefinition(ad);
    }

    public static ComplexXercesTypeDefinition createTypeDefinition(XSComplexTypeDefinition ad) {
        return new ComplexXercesTypeDefinition(ad);
    }
}

