/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.structure;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.AbstractCommand;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDSchema;

public final class MakeLocalElementGlobalCommand
extends AbstractCommand {
    public MakeLocalElementGlobalCommand(XSDConcreteComponent element) {
        super(element.getContainer());
        this.setModelObject(element);
    }

    public void run() {
        if (this.getModelObject() instanceof XSDElementDeclaration) {
            boolean elementExists;
            String localElementName;
            XSDElementDeclaration localElementDeclaration = (XSDElementDeclaration)this.getModelObject();
            XSDConcreteComponent parent = this.getParent();
            XSDConcreteComponent container = parent.getContainer();
            XSDElementDeclaration globalElementDeclaration = (XSDElementDeclaration)localElementDeclaration.cloneConcreteComponent(true, false);
            XSDSchema schema = container.getSchema();
            XSDElementDeclaration existingGlobalElement = schema.resolveElementDeclaration(localElementName = localElementDeclaration.getName());
            boolean bl = elementExists = existingGlobalElement != null && existingGlobalElement.getSchema() != null;
            if (elementExists) {
                String newElementName = XSDCommonUIUtils.createUniqueElementName(localElementName, (List)schema.getElementDeclarations());
                globalElementDeclaration.setName(newElementName);
            }
            EList schemaContents = schema.getContents();
            schemaContents.add((Object)globalElementDeclaration);
            localElementDeclaration.setName(null);
            localElementDeclaration.setTypeDefinition(null);
            localElementDeclaration.setAnonymousTypeDefinition(null);
            localElementDeclaration.setResolvedElementDeclaration(globalElementDeclaration);
            XSDModelGroup modelGroup = (XSDModelGroup)container;
            this.formatChild(modelGroup.getElement());
            this.formatChild(globalElementDeclaration.getElement());
        }
    }

    protected boolean adopt(XSDConcreteComponent model) {
        return true;
    }
}

