/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.ui.internal.assembly.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElementLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.ui.internal.JstCommonUIPlugin;
import org.eclipse.jst.common.ui.internal.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;

public class VariableReferenceWizardFragment
extends WizardFragment {
    protected LabelProvider labelProvider = null;
    protected ITreeContentProvider contentProvider = null;
    protected TreeViewer viewer;
    protected IPath[] paths;
    protected IWizardHandle handle;
    protected Object selected = null;
    boolean isComplete = false;
    private CPVariableElement[] elements;

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setTitle(Messages.VariableReferenceTitle);
        handle.setDescription(Messages.VariableReferenceDescription);
        handle.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        Composite c = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.jst.common.ui.DEPLOYMENT_ASSEMBLY_NEW_VARIABLE_REFERENCE_P1");
        c.setLayout((Layout)new FormLayout());
        this.viewer = new TreeViewer(c, 2052);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariableReferenceWizardFragment.this.handleNewSelection();
            }
        });
        FormData fd = new FormData();
        fd.width = 390;
        fd.height = 185;
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -5);
        this.viewer.getTree().setLayoutData((Object)fd);
        return c;
    }

    protected void handleNewSelection() {
        this.isComplete = true;
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object o = sel.getFirstElement();
        if (o == null) {
            this.isComplete = false;
            this.selected = null;
        } else {
            this.selected = o;
            IPath p = null;
            if (o instanceof CPVariableElement) {
                p = ((CPVariableElement)o).getPath();
            } else if (o instanceof ExtendedVariable) {
                p = ((ExtendedVariable)o).element.getPath().append(((ExtendedVariable)o).pathAfterElement);
            }
            if (p == null || p.isEmpty() || p.toFile().isDirectory() || !this.isValidArchive(p)) {
                this.isComplete = false;
            }
        }
        this.handle.update();
    }

    protected LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new VariablesLabelProvider();
        }
        return this.labelProvider;
    }

    private CPVariableElement[] initializeElements() {
        String[] entries = JavaCore.getClasspathVariableNames();
        ArrayList<CPVariableElement> elements = new ArrayList<CPVariableElement>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String name = entries[i];
            IPath entryPath = JavaCore.getClasspathVariable((String)name);
            if (entryPath != null) {
                elements.add(new CPVariableElement(name, entryPath));
            }
            ++i;
        }
        return elements.toArray(new CPVariableElement[elements.size()]);
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (VariableReferenceWizardFragment.this.elements == null) {
                        VariableReferenceWizardFragment.this.elements = VariableReferenceWizardFragment.this.initializeElements();
                    }
                    return VariableReferenceWizardFragment.this.elements;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return this.getChildren(element).length > 0;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof CPVariableElement && ((CPVariableElement)parentElement).getPath().toFile().isDirectory()) {
                        String[] names = ((CPVariableElement)parentElement).getPath().toFile().list();
                        Object[] extensions = new ExtendedVariable[names.length];
                        int i = 0;
                        while (i < extensions.length) {
                            extensions[i] = new ExtendedVariable((CPVariableElement)parentElement, (IPath)new Path(names[i]));
                            ++i;
                        }
                        return extensions;
                    }
                    if (parentElement instanceof ExtendedVariable) {
                        ExtendedVariable p1 = (ExtendedVariable)parentElement;
                        IPath parentLoc = p1.element.getPath();
                        String[] names = (parentLoc = parentLoc.append(p1.pathAfterElement)).toFile().list();
                        if (names != null) {
                            Object[] extensions = new ExtendedVariable[names.length];
                            int i = 0;
                            while (i < extensions.length) {
                                extensions[i] = new ExtendedVariable(p1.element, p1.pathAfterElement.append(names[i]));
                                ++i;
                            }
                            return extensions;
                        }
                    }
                    return new Object[0];
                }
            };
        }
        return this.contentProvider;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent rootComponent = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        String runtimeLoc = (String)this.getTaskModel().getObject("default.library.location");
        if (this.selected != null) {
            ArrayList<VirtualReference> refList = new ArrayList<VirtualReference>();
            IPath variablePath = this.getVariablePath(this.selected);
            IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)variablePath);
            File file = new File(resolvedPath.toOSString());
            if (file.isFile() && file.exists()) {
                String type = "var/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + variablePath.toString()));
                VirtualReference ref = new VirtualReference(rootComponent, archive);
                ref.setArchiveName(resolvedPath.lastSegment());
                if (runtimeLoc != null) {
                    ref.setRuntimePath(new Path(runtimeLoc).makeAbsolute());
                }
                refList.add(ref);
            }
            IVirtualReference[] finalRefs = refList.toArray(new IVirtualReference[refList.size()]);
            this.getTaskModel().putObject("dependency.reference.final", (Object)finalRefs);
        }
    }

    private IPath getVariablePath(Object selected) {
        if (selected instanceof ExtendedVariable) {
            ExtendedVariable s1 = (ExtendedVariable)selected;
            return new Path(s1.element.getName()).append(s1.pathAfterElement);
        }
        return new Path(((CPVariableElement)selected).getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidArchive(IPath path) {
        boolean valid = true;
        ZipFile zipFile = null;
        try {
            try {
                IPath loc;
                IFile file;
                String osPath = null;
                if (path.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists() && (loc = file.getLocation()) != null) {
                    osPath = loc.toOSString();
                }
                if (osPath == null) {
                    osPath = path.toOSString();
                }
                zipFile = new ZipFile(new File(osPath));
                return valid;
            }
            catch (ZipException zipException) {
                valid = false;
                if (zipFile == null) return valid;
                try {
                    zipFile.close();
                    return valid;
                }
                catch (IOException e) {
                    JstCommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.common.ui", e.getMessage(), (Throwable)e));
                }
                return valid;
            }
            catch (IOException iOException) {
                valid = false;
                if (zipFile == null) return valid;
                try {
                    zipFile.close();
                    return valid;
                }
                catch (IOException e) {
                    JstCommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.common.ui", e.getMessage(), (Throwable)e));
                }
                return valid;
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    JstCommonUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.common.ui", e.getMessage(), (Throwable)e));
                }
            }
        }
    }

    public static class ExtendedVariable {
        public CPVariableElement element;
        public IPath pathAfterElement;

        public ExtendedVariable(CPVariableElement e, IPath p) {
            this.element = e;
            this.pathAfterElement = p;
        }

        public boolean isFolder() {
            return this.element.getPath().append(this.pathAfterElement).toFile().isDirectory();
        }
    }

    public static class VariablesLabelProvider
    extends LabelProvider {
        private CPVariableElementLabelProvider delegate = new CPVariableElementLabelProvider(false);

        public Image getImage(Object element) {
            if (element instanceof CPVariableElement) {
                return this.delegate.getImage(element);
            }
            if (element instanceof ExtendedVariable) {
                if (((ExtendedVariable)element).isFolder()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CPVariableElement) {
                return this.delegate.getText(element);
            }
            if (element instanceof ExtendedVariable) {
                return ((ExtendedVariable)element).pathAfterElement.lastSegment();
            }
            return element == null ? "" : element.toString();
        }
    }
}

