/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushWizardDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class PushCommitHandler
extends AbstractHistoryCommandHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlotCommit commit = (PlotCommit)this.getSelection(event).getFirstElement();
        Repository repo = this.getRepository(event);
        try {
            PushBranchWizard wizard = null;
            Ref localBranch = this.findLocalBranch(commit);
            wizard = localBranch == null ? new PushBranchWizard(repo, commit.getId()) : new PushBranchWizard(repo, localBranch);
            PushWizardDialog dlg = new PushWizardDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (IWizard)wizard);
            dlg.setHelpAvailable(true);
            dlg.open();
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return null;
    }

    private Ref findLocalBranch(PlotCommit commit) {
        int i = 0;
        while (i < commit.getRefCount()) {
            Ref currentRef = commit.getRef(i);
            if (currentRef.getName().startsWith("refs/heads/")) {
                return currentRef;
            }
            ++i;
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection sel = this.getSelection(page);
        return sel.size() == 1 && sel.getFirstElement() instanceof RevCommit;
    }

    public void updateElement(UIElement element, Map parameters) {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return;
        }
        IStructuredSelection sel = this.getSelection(page);
        Object item = sel.size() == 1 ? sel.getFirstElement() : null;
        Ref ref = null;
        if (item instanceof PlotCommit) {
            ref = this.findLocalBranch((PlotCommit)item);
        }
        if (ref != null) {
            element.setText(UIText.PushCommitHandler_pushBranchLabel);
        } else {
            element.setText(UIText.PushCommitHandler_pushCommitLabel);
        }
    }
}

