/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.IASDAddCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBindingCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public class W11AddBindingCommand
extends W11TopLevelElementCommand
implements IASDAddCommand {
    private String newName;
    private Binding newBinding;

    public W11AddBindingCommand(Definition definition) {
        super(Messages._UI_ACTION_ADD_BINDING, definition);
    }

    public void setNewBindingName(String newName) {
        this.newName = newName;
    }

    public Binding getNewBinding() {
        return this.newBinding;
    }

    @Override
    public void execute() {
        try {
            this.beginRecording(this.definition.getElement());
            super.execute();
            if (this.newName == null || this.newName.equals("")) {
                this.newName = NameUtil.buildUniqueBindingName(this.definition, "NewBinding");
            }
            AddBindingCommand command = new AddBindingCommand(this.definition, this.newName);
            command.run();
            this.newBinding = (Binding)command.getWSDLElement();
            this.formatChild(this.newBinding.getElement());
        }
        finally {
            this.endRecording(this.definition.getElement());
        }
    }

    @Override
    public Object getNewlyAddedComponent() {
        return this.newBinding;
    }
}

