/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryFinder {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryFinder.class.getName());
    private static final Class mySpi = EngineConfigurationFactory.class;
    private static final Class[] newFactoryParamTypes = new Class[]{Object.class};
    private static final String requiredMethod = "public static EngineConfigurationFactory newFactory(Object)";

    private EngineConfigurationFactoryFinder() {
    }

    public static EngineConfigurationFactory newFactory(Object obj) {
        final Object[] params = new Object[]{obj};
        return (EngineConfigurationFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator services = AxisProperties.getResourceClassIterator(mySpi);
                Object factory = null;
                while (factory == null && services.hasNext()) {
                    try {
                        Class service = services.nextResourceClass().loadClass();
                        if (service == null) continue;
                        factory = EngineConfigurationFactoryFinder.newFactory(service, newFactoryParamTypes, params);
                    }
                    catch (Exception exception) {}
                }
                if (factory != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage("engineFactory", factory.getClass().getName()));
                    }
                } else {
                    log.error((Object)Messages.getMessage("engineConfigFactoryMissing"));
                }
                return factory;
            }
        });
    }

    public static EngineConfigurationFactory newFactory() {
        return EngineConfigurationFactoryFinder.newFactory(null);
    }

    private static EngineConfigurationFactory newFactory(Class service, Class[] paramTypes, Object[] param) {
        block8: {
            try {
                Method method = ClassUtils.findPublicStaticMethod((Class)service, (Class)EngineConfigurationFactory.class, (String)"newFactory", (Class[])paramTypes);
                if (method == null) {
                    log.warn((Object)Messages.getMessage("engineConfigMissingNewFactory", service.getName(), requiredMethod));
                    break block8;
                }
                try {
                    return (EngineConfigurationFactory)method.invoke(null, param);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof NoClassDefFoundError) {
                        log.debug((Object)Messages.getMessage("engineConfigLoadFactory", service.getName()));
                    } else {
                        log.warn((Object)Messages.getMessage("engineConfigInvokeNewFactory", service.getName(), requiredMethod), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)Messages.getMessage("engineConfigInvokeNewFactory", service.getName(), requiredMethod), (Throwable)e);
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug((Object)Messages.getMessage("engineConfigLoadFactory", service.getName()));
            }
        }
        return null;
    }

    static {
        AxisProperties.setClassOverrideProperty(EngineConfigurationFactory.class, "axis.EngineConfigFactory");
        AxisProperties.setClassDefaults(EngineConfigurationFactory.class, new String[]{"org.apache.axis.configuration.EngineConfigurationFactoryServlet", "org.apache.axis.configuration.EngineConfigurationFactoryDefault"});
    }
}

