/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IAssignment;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class Assignment
extends Expression
implements IAssignment {
    public Expression lhs;
    public Expression expression;
    public Javadoc javadoc;
    public InferredType inferredType;
    private boolean fIsType;
    private IFunctionDeclaration fContainingFunction;

    public Assignment(Expression lhs, Expression expression, int sourceEnd) {
        this.lhs = lhs;
        lhs.bits |= 0x2000;
        this.expression = expression;
        this.sourceStart = lhs.sourceStart;
        this.sourceEnd = sourceEnd;
        this.fIsType = false;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding local = this.lhs.localVariableBinding();
        int nullStatus = this.expression.nullStatus(flowInfo);
        if (local != null && (local.type.tagBits & 2L) == 0L && nullStatus == 1) {
            flowContext.recordUsingNullReference(currentScope, local, this.lhs, 769, flowInfo);
        }
        flowInfo = ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, false).unconditionalInits();
        if (local != null && (local.type.tagBits & 2L) == 0L) {
            switch (nullStatus) {
                case 1: {
                    flowInfo.markAsDefinitelyNull(local);
                    break;
                }
                case -1: {
                    flowInfo.markAsDefinitelyNonNull(local);
                    break;
                }
                default: {
                    flowInfo.markAsDefinitelyUnknown(local);
                }
            }
            if (flowContext.initsOnFinally != null) {
                switch (nullStatus) {
                    case 1: {
                        flowContext.initsOnFinally.markAsDefinitelyNull(local);
                        break;
                    }
                    case -1: {
                        flowContext.initsOnFinally.markAsDefinitelyNonNull(local);
                        break;
                    }
                    default: {
                        flowContext.initsOnFinally.markAsDefinitelyUnknown(local);
                    }
                }
            }
        }
        return flowInfo;
    }

    public static Binding getDirectBinding(Expression someExpression) {
        if ((someExpression.bits & 0x20000000) != 0) {
            return null;
        }
        if (someExpression instanceof SingleNameReference) {
            return ((SingleNameReference)someExpression).binding;
        }
        if (someExpression instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)someExpression;
            if (fieldRef.receiver.isThis() && !(fieldRef.receiver instanceof QualifiedThisReference)) {
                return fieldRef.binding;
            }
        } else if (someExpression instanceof Assignment) {
            Expression lhs = ((Assignment)someExpression).lhs;
            if ((lhs.bits & 0x2000) != 0) {
                return Assignment.getDirectBinding(((Assignment)someExpression).lhs);
            }
            if (someExpression instanceof PrefixExpression) {
                return Assignment.getDirectBinding(((Assignment)someExpression).lhs);
            }
        }
        return null;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        Assignment.printIndent(indent, output);
        return this.printExpressionNoParenthesis(indent, output);
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        return this.printExpressionNoParenthesis(0, output).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.lhs.printExpression(indent, output).append(" = ");
        return this.expression.printExpression(0, output);
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(';');
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding lhsType;
        this.constant = Constant.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding rhsType = this.expression.resolveType(scope);
        if (this.getInferredType() != null && this.getInferredType().binding != null) {
            rhsType = this.getInferredType().binding;
        }
        if ((lhsType = this.lhs.resolveType(scope, true, rhsType)) != null) {
            this.resolvedType = lhsType;
        }
        if (lhsType == null || rhsType == null) {
            return null;
        }
        if (this.lhs instanceof FieldReference && ((FieldReference)this.lhs).isPrototype()) {
            return this.resolvedType;
        }
        Binding left = Assignment.getDirectBinding(this.lhs);
        if (left != null && left == Assignment.getDirectBinding(this.expression)) {
            scope.problemReporter().assignmentHasNoEffect(this, left.shortReadableName());
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(rhsType, lhsType) || lhsType.isBaseType() && BaseTypeBinding.isWidening(lhsType.id, rhsType.id) || rhsType.isCompatibleWith(lhsType)) {
            return this.resolvedType;
        }
        if (scope.isBoxingCompatibleWith(rhsType, lhsType) || rhsType.isBaseType() && scope.compilerOptions().sourceLevel >= 0x310000L && !lhsType.isBaseType() && this.expression.isConstantValueOfTypeAssignableToType(rhsType, scope.environment().computeBoxingType(lhsType))) {
            return this.resolvedType;
        }
        if (rhsType.isFunctionType() && this.lhs.isTypeReference()) {
            return lhsType;
        }
        return lhsType;
    }

    @Override
    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedType) {
        TypeBinding type = super.resolveTypeExpecting(scope, expectedType);
        if (type == null) {
            return null;
        }
        TypeBinding lhsType = this.resolvedType;
        if (expectedType == TypeBinding.BOOLEAN && lhsType == TypeBinding.BOOLEAN && (this.lhs.bits & 0x2000) != 0) {
            scope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        return type;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public LocalVariableBinding localVariableBinding() {
        return this.lhs.localVariableBinding();
    }

    @Override
    public int getASTType() {
        return 14;
    }

    @Override
    public IExpression getExpression() {
        return this.expression;
    }

    @Override
    public IExpression getLeftHandSide() {
        return this.lhs;
    }

    @Override
    public IJsDoc getJsDoc() {
        return this.javadoc;
    }

    @Override
    public void setInferredType(InferredType type) {
        this.inferredType = type;
    }

    @Override
    public InferredType getInferredType() {
        return this.inferredType;
    }

    public void setContainingFunction(IFunctionDeclaration containingFunction) {
        this.fContainingFunction = containingFunction;
    }

    public IFunctionDeclaration getContainingFunction() {
        return this.fContainingFunction;
    }

    @Override
    public void setIsType(boolean isType) {
        this.fIsType = isType;
    }

    @Override
    public boolean isType() {
        return this.fIsType;
    }
}

