/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.dialogs;

import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DefineTypeComposite {
    Button innerJoinRadio;
    Button leftOuterJoinRadio;
    Button rightOuterJoinRadio;
    Button fullOuterJoinRadio;
    SQLDomainModel domainModel;
    private Composite typeControls;

    public DefineTypeComposite(Composite parent, SQLDomainModel domainModel, int joinKind) {
        this.typeControls = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.typeControls, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0011");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.typeControls.setLayout((Layout)layout);
        this.typeControls.setLayoutData((Object)ViewUtility.createFill());
        this.domainModel = domainModel;
        this.createInputPanel(this.typeControls);
        this.initButtons(joinKind);
    }

    public Composite getControl() {
        return this.typeControls;
    }

    private void createInputPanel(Composite parent) {
        Group buttonGroup = ViewUtility.createGroup(parent, 1, Messages._UI_DEFINE_JOIN_DIALOG_INSTR, false);
        this.innerJoinRadio = ViewUtility.createRadioButton((Composite)buttonGroup, Messages._UI_RADIO_INNER_JOIN);
        this.leftOuterJoinRadio = ViewUtility.createRadioButton((Composite)buttonGroup, Messages._UI_RADIO_LEFT_OUTER_JOIN);
        this.rightOuterJoinRadio = ViewUtility.createRadioButton((Composite)buttonGroup, Messages._UI_RADIO_RIGHT_OUTER_JOIN);
        this.fullOuterJoinRadio = ViewUtility.createRadioButton((Composite)buttonGroup, Messages._UI_RADIO_FULL_OUTER_JOIN);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.innerJoinRadio, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0011");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.leftOuterJoinRadio, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0011");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.rightOuterJoinRadio, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0011");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fullOuterJoinRadio, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0011");
        if (this.domainModel.getVendor().isDB2() || this.domainModel.getVendor().isMSSQLServer() || this.domainModel.getVendor().isInstantDB()) {
            this.fullOuterJoinRadio.setEnabled(true);
        } else if (this.domainModel.getVendor().isInformix()) {
            this.fullOuterJoinRadio.setEnabled(false);
            this.leftOuterJoinRadio.setEnabled(false);
            this.rightOuterJoinRadio.setEnabled(false);
        } else {
            this.fullOuterJoinRadio.setEnabled(false);
        }
        String title = Messages._UI_DEFINE_JOIN_DIALOG_TITLE;
        Label filler = ViewUtility.createHorizontalFiller(parent, 1);
        filler.setText("       " + title + "      ");
        try {
            Font pFont = parent.getFont();
            if (pFont != null && pFont.getFontData() != null) {
                FontData pFontData = pFont.getFontData()[0];
                pFontData.setStyle(1);
                filler.setFont(new Font((Device)Display.getCurrent(), pFontData));
            }
        }
        catch (Exception exception) {}
        filler.setVisible(false);
        parent.setLayoutData((Object)ViewUtility.createFill());
    }

    public boolean isSet(int joinKind) {
        if (joinKind == 0) {
            return this.innerJoinRadio.getSelection();
        }
        if (joinKind == 2) {
            return this.leftOuterJoinRadio.getSelection();
        }
        if (joinKind == 3) {
            return this.rightOuterJoinRadio.getSelection();
        }
        return this.fullOuterJoinRadio.getSelection();
    }

    protected void initButtons(int joinKind) {
        if (joinKind == 0) {
            this.innerJoinRadio.setSelection(true);
        } else if (joinKind == 2) {
            this.leftOuterJoinRadio.setSelection(true);
        } else if (joinKind == 3) {
            this.rightOuterJoinRadio.setSelection(true);
        } else {
            this.fullOuterJoinRadio.setSelection(true);
        }
    }

    public int getJoinKind() {
        if (this.isSet(0)) {
            return 0;
        }
        if (this.isSet(2)) {
            return 2;
        }
        if (this.isSet(3)) {
            return 3;
        }
        return 4;
    }
}

