/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.libval;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.BundleReference;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class LibraryValidatorTools {
    private static final Transformer<IClasspathEntry, IPath> CLASSPATH_ENTRY_PATH_TRANSFORMER = new ClasspathEntryPathTransformer();

    public static IStatus validateClasses(UserLibraryProviderInstallOperationConfig config, Iterable<String> classNames) {
        return LibraryValidatorTools.validateClassesInClasspathEntries(config.resolve(), classNames);
    }

    private static IStatus validateClassesInClasspathEntries(Iterable<IClasspathEntry> libraryClasspathEntries, Iterable<String> classNames) {
        return LibraryValidatorTools.validateClassesInLibraries((Iterable<IPath>)new TransformationIterable(libraryClasspathEntries, CLASSPATH_ENTRY_PATH_TRANSFORMER), classNames);
    }

    private static IStatus validateClassesInLibraries(Iterable<IPath> libraryPaths, Iterable<String> classNames) {
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        HashMap<CallSite, String> classFileNameToClassName = new HashMap<CallSite, String>();
        for (String string : CollectionTools.hashSet(classNames)) {
            String classFileName = string.replace('.', '/') + ".class";
            flags.put(classFileName, Boolean.FALSE);
            classFileNameToClassName.put((CallSite)((Object)classFileName), string);
        }
        for (IPath iPath : libraryPaths) {
            LibraryValidatorTools.validate(iPath, flags);
        }
        for (Map.Entry entry : flags.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            String className = (String)classFileNameToClassName.get(entry.getKey());
            return LibraryValidatorTools.buildErrorStatus(JptCommonCoreMessages.USER_LIBRARY_VALIDATOR__CLASS_NOT_FOUND, className);
        }
        return Status.OK_STATUS;
    }

    private static void validate(IPath libraryPath, HashMap<String, Boolean> flags) {
        File file = libraryPath.toFile();
        if (file.exists()) {
            LibraryValidatorTools.validate(file, flags);
        }
    }

    private static void validate(File libraryFile, HashMap<String, Boolean> flags) {
        block15: {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(libraryFile);
                    Enumeration<? extends ZipEntry> stream = zip.entries();
                    while (stream.hasMoreElements()) {
                        ZipEntry zipEntry = stream.nextElement();
                        String name = zipEntry.getName();
                        if (!flags.containsKey(name)) continue;
                        flags.put(name, Boolean.TRUE);
                    }
                }
                catch (IOException iOException) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static IStatus validateBundleVersions(OsgiBundlesLibraryProviderInstallOperationConfig config, Map<String, VersionRange> bundleVersionRanges) {
        HashMap<String, Bundle> configBundles = new HashMap<String, Bundle>();
        for (BundleReference bundleReference : config.getBundleReferences()) {
            Bundle bundle = bundleReference.getBundle();
            configBundles.put(bundle.getSymbolicName(), bundle);
        }
        for (Map.Entry entry : bundleVersionRanges.entrySet()) {
            String bundleName = (String)entry.getKey();
            Bundle configBundle = (Bundle)configBundles.get(bundleName);
            if (configBundle == null) {
                return LibraryValidatorTools.buildErrorStatus(JptCommonCoreMessages.OSGI_BUNDLES_LIBRARY_VALIDATOR__BUNDLE_NOT_FOUND, bundleName);
            }
            Version configBundleVersion = configBundle.getVersion();
            VersionRange versionRange = (VersionRange)entry.getValue();
            if (versionRange.isIncluded(configBundleVersion)) continue;
            return LibraryValidatorTools.buildErrorStatus(JptCommonCoreMessages.OSGI_BUNDLES_LIBRARY_VALIDATOR__IMPROPER_BUNDLE_VERSION, bundleName);
        }
        return Status.OK_STATUS;
    }

    public static IProjectFacetVersion getJavaFacetVersion(JptLibraryProviderInstallOperationConfig config) {
        return config.getFacetedProject().getProjectFacetVersion(JavaFacet.FACET);
    }

    private static IStatus buildErrorStatus(String message, Object ... args) {
        return JptCommonCorePlugin.instance().buildErrorStatus(message, args);
    }

    static class ClasspathEntryPathTransformer
    extends TransformerAdapter<IClasspathEntry, IPath> {
        ClasspathEntryPathTransformer() {
        }

        public IPath transform(IClasspathEntry classpathEntry) {
            return classpathEntry.getPath();
        }
    }
}

