/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.verifier.impl;

import java.util.Enumeration;
import jp.gr.xml.relax.dom.DOMVisitorException;
import jp.gr.xml.relax.dom.IDOMVisitor;
import jp.gr.xml.relax.dom.UDOM;
import jp.gr.xml.relax.dom.UDOMVisitor;
import jp.gr.xml.relax.sax.DeclHandlerBase;
import jp.gr.xml.relax.sax.LexicalHandlerBase;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXEventGenerator
implements IDOMVisitor {
    private Node root_;
    private boolean needDocumentEmulation_ = true;
    private String systemID_;
    private String publicID_;
    private DTDHandler dtd_;
    private ContentHandler content_;
    private DeclHandler decl_;
    private LexicalHandler lexical_;
    private ErrorHandler error_;
    private final NamespaceSupport namespace_ = new NamespaceSupport();

    public SAXEventGenerator(Node node) {
        this.root_ = node;
        DefaultHandler handler = new DefaultHandler();
        this.dtd_ = handler;
        this.content_ = handler;
        this.error_ = handler;
        this.lexical_ = new LexicalHandlerBase();
        this.decl_ = new DeclHandlerBase();
    }

    public void setDocumentEmulation(boolean emulate) {
        this.needDocumentEmulation_ = emulate;
    }

    public void setDTDHandler(DTDHandler dtd) {
        this.dtd_ = dtd;
    }

    public void setContentHandler(ContentHandler content) {
        this.content_ = content;
    }

    public void setLexicalHandler(LexicalHandler lexical) {
        this.lexical_ = lexical;
    }

    public void setDeclHandler(DeclHandler decl) {
        this.decl_ = decl;
    }

    public void setErrorHandler(ErrorHandler error) {
        this.error_ = error;
    }

    public void makeEvent() throws SAXException {
        try {
            if (!(this.root_ instanceof Document) && this.needDocumentEmulation_) {
                this.emulateStartDocument();
                UDOMVisitor.traverse(this.root_, this);
                this.emulateEndDocument();
            } else {
                UDOMVisitor.traverse(this.root_, this);
            }
        }
        catch (DOMVisitorException e) {
            Exception cause = e.getCauseException();
            if (cause == null) {
                throw new SAXException(e.getMessage());
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new SAXException(e.getMessage());
        }
    }

    public void makeEvent(ContentHandler handler) throws SAXException {
        this.setContentHandler(handler);
        this.makeEvent();
    }

    public void emulateStartDocument() {
        try {
            this._handleLocator();
            this.content_.startDocument();
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    public void emulateEndDocument() {
        try {
            this.content_.endDocument();
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    public boolean enter(Element element) {
        try {
            this.namespace_.pushContext();
            String namespaceURI = element.getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            String localName = element.getLocalName();
            String qName = element.getTagName();
            if (localName == null) {
                localName = qName;
            }
            NamedNodeMap attrMap = element.getAttributes();
            AttributesImpl attrs = new AttributesImpl();
            int size = attrMap.getLength();
            int i = 0;
            while (i < size) {
                Attr attr = (Attr)attrMap.item(i);
                String attrNamespaceURI = attr.getNamespaceURI();
                if (attrNamespaceURI == null) {
                    attrNamespaceURI = "";
                }
                String attrLocalName = attr.getLocalName();
                String attrQName = attr.getName();
                if (attrLocalName == null) {
                    attrLocalName = attrQName;
                }
                String attrValue = attr.getValue();
                if (attrQName.startsWith("xmlns")) {
                    int index = attrQName.indexOf(58);
                    String prefix = index == -1 ? "" : attrQName.substring(index + 1);
                    if (!this.namespace_.declarePrefix(prefix, attrValue)) {
                        this._errorReport("bad prefix = " + prefix);
                    } else {
                        this.content_.startPrefixMapping(prefix, attrValue);
                    }
                } else {
                    attrs.addAttribute(attrNamespaceURI, attrLocalName, attrQName, "CDATA", attrValue);
                }
                ++i;
            }
            this.content_.startElement(namespaceURI, localName, qName, attrs);
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return true;
    }

    public boolean enter(Attr attr) {
        return false;
    }

    public boolean enter(Text text) {
        try {
            String data = text.getData();
            this.content_.characters(data.toCharArray(), 0, data.length());
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return false;
    }

    public boolean enter(CDATASection cdata) {
        try {
            this.lexical_.startCDATA();
            String data = cdata.getData();
            this.content_.characters(data.toCharArray(), 0, data.length());
            this.lexical_.endCDATA();
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return false;
    }

    public boolean enter(EntityReference entityRef) {
        try {
            this.lexical_.startEntity(entityRef.getNodeName());
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return true;
    }

    public boolean enter(Entity entity) {
        return false;
    }

    public boolean enter(ProcessingInstruction pi) {
        try {
            this.content_.processingInstruction(pi.getTarget(), pi.getData());
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return false;
    }

    public boolean enter(Comment comment) {
        try {
            String data = comment.getData();
            this.lexical_.comment(data.toCharArray(), 0, data.length());
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return false;
    }

    public boolean enter(Document doc) {
        try {
            this._handleLocator();
            this.content_.startDocument();
            this._handleDoctype(doc.getDoctype());
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
        return true;
    }

    private void _handleLocator() {
        if (this.systemID_ == null && this.publicID_ == null) {
            return;
        }
        this._locatorEvent(this.systemID_, this.publicID_);
    }

    private void _locatorEvent(String systemID, String publicID) {
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(this.systemID_);
        locator.setPublicId(this.publicID_);
        locator.setLineNumber(-1);
        locator.setColumnNumber(-1);
        this.content_.setDocumentLocator(locator);
    }

    private void _handleDoctype(DocumentType doctype) {
        try {
            if (doctype == null) {
                return;
            }
            String systemID = doctype.getSystemId();
            String publicID = doctype.getPublicId();
            String internalSubset = doctype.getInternalSubset();
            if (systemID != null) {
                this.lexical_.startDTD(doctype.getName(), publicID, systemID);
                if (internalSubset == null) {
                    this.lexical_.endDTD();
                    this._handleEntities(doctype);
                } else {
                    this._handleEntities(doctype);
                    this.lexical_.endDTD();
                }
            } else {
                this._handleEntities(doctype);
            }
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    private void _handleEntities(DocumentType doctype) {
        try {
            NamedNodeMap entities = doctype.getEntities();
            int nEntities = entities.getLength();
            int i = 0;
            while (i < nEntities) {
                Entity entity = (Entity)entities.item(i);
                String publicID = entity.getPublicId();
                String systemID = entity.getSystemId();
                String notationName = entity.getNotationName();
                if (publicID != null || systemID != null) {
                    this._handleExternalEntity(entity.getNodeName(), publicID, systemID, notationName);
                } else {
                    this._handleInternalEntity(entity);
                }
                ++i;
            }
            NamedNodeMap notations = doctype.getNotations();
            int nNotations = notations.getLength();
            int i2 = 0;
            while (i2 < nNotations) {
                Notation notation = (Notation)notations.item(i2);
                String publicID = notation.getPublicId();
                String systemID = notation.getSystemId();
                this.dtd_.notationDecl(notation.getNodeName(), publicID, systemID);
                ++i2;
            }
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    private void _handleExternalEntity(String name, String publicID, String systemID, String notationName) {
        try {
            if (notationName == null) {
                this.decl_.externalEntityDecl(name, publicID, systemID);
            } else {
                this.dtd_.unparsedEntityDecl(name, publicID, systemID, notationName);
            }
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    private void _handleInternalEntity(Entity entity) {
        try {
            this.decl_.internalEntityDecl(entity.getNodeName(), UDOM.getXMLText(entity));
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    public boolean enter(DocumentType doctype) {
        return false;
    }

    public boolean enter(DocumentFragment docfrag) {
        return true;
    }

    public boolean enter(Notation notation) {
        return false;
    }

    public boolean enter(Node node) {
        return false;
    }

    public void leave(Element element) {
        try {
            String namespaceURI = element.getNamespaceURI();
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            String localName = element.getLocalName();
            String qName = element.getTagName();
            if (localName == null) {
                localName = qName;
            }
            this.content_.endElement(namespaceURI, localName, qName);
            Enumeration e = this.namespace_.getDeclaredPrefixes();
            while (e.hasMoreElements()) {
                this.content_.endPrefixMapping((String)e.nextElement());
            }
            this.namespace_.popContext();
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    public void leave(Attr attr) {
    }

    public void leave(Text text) {
    }

    public void leave(CDATASection cdata) {
    }

    public void leave(EntityReference entityRef) {
        try {
            this.lexical_.endEntity(entityRef.getNodeName());
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    public void leave(Entity entity) {
    }

    public void leave(ProcessingInstruction pi) {
    }

    public void leave(Comment comment) {
    }

    public void leave(Document doc) {
        try {
            this.content_.endDocument();
        }
        catch (SAXException e) {
            this._errorReport(e);
        }
    }

    public void leave(DocumentType doctype) {
    }

    public void leave(DocumentFragment docfrag) {
    }

    public void leave(Notation notation) {
    }

    public void leave(Node node) {
    }

    private void _errorReport(String message) throws DOMVisitorException {
        this._errorReport(new SAXParseException(message, this.publicID_, this.systemID_, -1, -1));
    }

    private void _errorReport(SAXException e) throws DOMVisitorException {
        try {
            SAXParseException parseException = e instanceof SAXParseException ? (SAXParseException)e : new SAXParseException(e.getMessage(), this.publicID_, this.systemID_, -1, -1, e);
            this.error_.fatalError(parseException);
            throw new DOMVisitorException(e);
        }
        catch (SAXException ee) {
            throw new DOMVisitorException(ee);
        }
    }
}

