/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.InspectAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class WatchAction
extends InspectAction {
    @Override
    public void run() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)selectedObject;
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                try {
                    this.createWatchExpression(((IJavaVariable)elements.next()).getName());
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                    return;
                }
            }
            this.showExpressionView();
        } else if (selectedObject instanceof String) {
            this.createWatchExpression((String)selectedObject);
            this.showExpressionView();
        }
    }

    private void createWatchExpression(String snippet) {
        if (snippet.isEmpty()) {
            return;
        }
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(snippet);
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
    }
}

