/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.subscriber;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.subscriber.SubscriberProviderDescriptor;
import org.eclipse.emf.compare.ide.ui.subscriber.SubscriberProviderRegistry;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;

public class SubscriberProviderRegistryListener
extends AbstractRegistryEventListener {
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_RANKING = "ranking";
    private final SubscriberProviderRegistry registry;

    public SubscriberProviderRegistryListener(String pluginID, String extensionPointID, ILog log, SubscriberProviderRegistry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        if (PROVIDER_ELEMENT_NAME.equals(element.getName())) {
            String className = element.getAttribute(ATTRIBUTE_CLASS);
            return className != null && className.trim().length() > 0;
        }
        return false;
    }

    protected boolean addedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        String rankingStr = element.getAttribute(ATTRIBUTE_RANKING);
        int ranking = -1;
        try {
            ranking = Integer.parseInt(rankingStr);
        }
        catch (NumberFormatException e) {
            this.log(4, element, EMFCompareIDEUIMessages.getString("ModelResolverRegistry.invalidRanking", className, rankingStr));
        }
        SubscriberProviderDescriptor descriptor = new SubscriberProviderDescriptor(ATTRIBUTE_CLASS, element, ranking);
        this.registry.addProvider(className, descriptor);
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        this.registry.removeProvider(className);
        return true;
    }
}

