/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.properties;

import java.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class SetPropertyValueCommand
extends Command {
    protected static final Object DEFAULT_VALUE = new Object();
    private final Object newValue;
    private Object oldValue;
    private final Object propertyId;
    private final IPropertySource propertySource;

    public SetPropertyValueCommand(String propertyLabel, IPropertySource propertySource, Object propertyId, Object newValue) {
        super(MessageFormat.format(GEFMessages.SetPropertyValueCommand_Label, propertyLabel).trim());
        this.propertySource = propertySource;
        this.propertyId = propertyId;
        this.newValue = newValue;
    }

    @Override
    public boolean canExecute() {
        if (this.propertySource == null || this.propertyId == null) {
            return false;
        }
        if (this.newValue == DEFAULT_VALUE) {
            boolean canExecute = this.propertySource.isPropertySet(this.propertyId);
            IPropertySource iPropertySource = this.propertySource;
            if (iPropertySource instanceof IPropertySource2) {
                IPropertySource2 propertySource2 = (IPropertySource2)iPropertySource;
                canExecute &= propertySource2.isPropertyResettable(this.propertyId);
            }
            return canExecute;
        }
        return true;
    }

    @Override
    public void execute() {
        boolean wasPropertySet = this.propertySource.isPropertySet(this.propertyId);
        this.oldValue = SetPropertyValueCommand.unwrapValue(this.propertySource.getPropertyValue(this.propertyId));
        if (this.newValue == DEFAULT_VALUE) {
            this.propertySource.resetPropertyValue(this.propertyId);
        } else {
            this.propertySource.setPropertyValue(this.propertyId, SetPropertyValueCommand.unwrapValue(this.newValue));
        }
        IPropertySource iPropertySource = this.propertySource;
        if (iPropertySource instanceof IPropertySource2) {
            IPropertySource2 propertySource2 = (IPropertySource2)iPropertySource;
            if (!wasPropertySet && propertySource2.isPropertyResettable(this.propertyId)) {
                this.oldValue = DEFAULT_VALUE;
            }
        } else if (!wasPropertySet && this.propertySource.isPropertySet(this.propertyId)) {
            this.oldValue = DEFAULT_VALUE;
        }
    }

    protected Object getNewValue() {
        return this.newValue;
    }

    protected Object getOldValue() {
        return this.oldValue;
    }

    protected Object getPropertyId() {
        return this.propertyId;
    }

    protected IPropertySource getPropertySource() {
        return this.propertySource;
    }

    @Override
    public void redo() {
        this.execute();
    }

    @Override
    public void undo() {
        if (this.oldValue == DEFAULT_VALUE) {
            this.propertySource.resetPropertyValue(this.propertyId);
        } else {
            this.propertySource.setPropertyValue(this.propertyId, this.oldValue);
        }
    }

    private static Object unwrapValue(Object value) {
        if (value instanceof IPropertySource) {
            IPropertySource propertySource = (IPropertySource)value;
            return propertySource.getEditableValue();
        }
        return value;
    }
}

