/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.dcmd;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import jdk.test.lib.dcmd.CommandExecutorException;
import jdk.test.lib.dcmd.PidJcmdExecutor;

public class FileJcmdExecutor
extends PidJcmdExecutor {
    public FileJcmdExecutor() {
    }

    public FileJcmdExecutor(String target) {
        super(target);
    }

    @Override
    protected List<String> createCommandLine(String cmd) throws CommandExecutorException {
        File cmdFile = this.createTempFile();
        this.writeCommandToTemporaryFile(cmd, cmdFile);
        return Arrays.asList(this.jcmdBinary, Long.toString(this.pid), "-f", cmdFile.getAbsolutePath());
    }

    private void writeCommandToTemporaryFile(String cmd, File cmdFile) {
        try (PrintWriter pw = new PrintWriter(cmdFile);){
            pw.println(cmd);
        }
        catch (IOException e) {
            String message = "Could not write to file: " + cmdFile.getAbsolutePath();
            throw new CommandExecutorException(message, e);
        }
    }

    private File createTempFile() {
        try {
            File cmdFile = File.createTempFile("input", "jcmd");
            cmdFile.deleteOnExit();
            return cmdFile;
        }
        catch (IOException e) {
            throw new CommandExecutorException("Could not create temporary file", e);
        }
    }
}

