/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.io.IOException;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.JavaLazyReadObject;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Snapshot;

public class JavaObjectArray
extends JavaLazyReadObject {
    private Object clazz;

    public JavaObjectArray(long classID, long offset) {
        super(offset);
        this.clazz = JavaObjectArray.makeId(classID);
    }

    @Override
    public JavaClass getClazz() {
        return (JavaClass)this.clazz;
    }

    @Override
    public void resolve(Snapshot snapshot) {
        JavaHeapObject t;
        if (this.clazz instanceof JavaClass) {
            return;
        }
        long classID = JavaObjectArray.getIdValue((Number)this.clazz);
        if (snapshot.isNewStyleArrayClass() && (t = snapshot.findThing(classID)) instanceof JavaClass) {
            this.clazz = (JavaClass)t;
        }
        if (!(this.clazz instanceof JavaClass) && (t = snapshot.findThing(classID)) != null && t instanceof JavaClass) {
            JavaClass el = (JavaClass)t;
            Object nm = el.getName();
            if (!((String)nm).startsWith("[")) {
                nm = "L" + el.getName() + ";";
            }
            this.clazz = snapshot.getArrayClass((String)nm);
        }
        if (!(this.clazz instanceof JavaClass)) {
            this.clazz = snapshot.getOtherArrayType();
        }
        ((JavaClass)this.clazz).addInstance(this);
        super.resolve(snapshot);
    }

    public JavaThing[] getValues() {
        return this.getElements();
    }

    public JavaThing[] getElements() {
        return this.getValue();
    }

    @Override
    public int compareTo(JavaThing other) {
        if (other instanceof JavaObjectArray) {
            return 0;
        }
        return super.compareTo(other);
    }

    public int getLength() {
        return (int)(this.getValueLength() / (long)this.idSize());
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        super.visitReferencedObjects(v);
        JavaThing[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null || !(elements[i] instanceof JavaHeapObject)) continue;
            v.visit((JavaHeapObject)elements[i]);
        }
    }

    @Override
    public String describeReferenceTo(JavaThing target, Snapshot ss) {
        JavaThing[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != target) continue;
            return "Element " + i + " of " + String.valueOf(this);
        }
        return super.describeReferenceTo(target, ss);
    }

    @Override
    protected final long readValueLength() throws IOException {
        long offset = this.getOffset() + (long)this.idSize() + 4L;
        long len = this.buf().getInt(offset);
        return len * (long)this.idSize();
    }

    private long dataStartOffset() {
        return this.getOffset() + (long)this.idSize() + 4L + 4L + (long)this.idSize();
    }

    @Override
    protected final JavaThing[] readValue() throws IOException {
        Snapshot snapshot = this.getClazz().getSnapshot();
        int len = this.getLength();
        long offset = this.dataStartOffset();
        JavaThing[] res = new JavaThing[len];
        for (int i = 0; i < len; ++i) {
            long id = this.objectIdAt(offset);
            res[i] = snapshot.findThing(id);
            offset += (long)this.idSize();
        }
        return res;
    }
}

