/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.test.lib.security.DiffieHellmanGroup;

public final class SecurityUtils {
    private static final int DEFAULT_SALTSIZE = 16;

    private static String getCacerts() {
        String sep = File.separator;
        return System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts";
    }

    public static KeyStore getCacertsKeyStore() throws Exception {
        File file = new File(SecurityUtils.getCacerts());
        if (!file.exists()) {
            return null;
        }
        return KeyStore.getInstance(file, (char[])null);
    }

    public static void addToDisabledTlsAlgs(String ... protocols) {
        SecurityUtils.addToDisabledArgs("jdk.tls.disabledAlgorithms", List.of(protocols));
    }

    public static void addToDisabledArgs(String prop, List<String> constraints) {
        String value = Security.getProperty(prop);
        value = Stream.concat(Arrays.stream(value.split(",")), constraints.stream()).map(String::trim).collect(Collectors.joining(","));
        Security.setProperty(prop, value);
    }

    public static void removeFromDisabledTlsAlgs(String ... protocols) {
        SecurityUtils.removeFromDisabledAlgs("jdk.tls.disabledAlgorithms", List.of(protocols));
    }

    public static void removeFromDisabledAlgs(String prop, List<String> constraints) {
        String value = Security.getProperty(prop);
        value = Arrays.stream(value.split(",")).map(s -> s.trim()).filter(s -> constraints.stream().allMatch(constraint -> !s.contains((CharSequence)constraint))).collect(Collectors.joining(","));
        Security.setProperty(prop, value);
    }

    public static void removeAlgsFromDSigPolicy(String ... algs) {
        SecurityUtils.removeFromDSigPolicy("disallowAlg", List.of(algs));
    }

    public static int getTestSaltSize() {
        return 16;
    }

    public static int getTestKeySize(String algo) {
        return switch (algo) {
            case "RSA" -> KeySize.RSA.keySize;
            case "DSA" -> KeySize.DSA.keySize;
            case "Ed25519" -> KeySize.Ed25519.keySize;
            case "EC" -> KeySize.EC.keySize;
            case "DH", "DiffieHellman" -> KeySize.DH.keySize;
            default -> throw new RuntimeException("Test key size not defined for " + algo);
        };
    }

    public static DiffieHellmanGroup getTestDHGroup() {
        return SecurityUtils.getTestDHGroup(2048);
    }

    public static DiffieHellmanGroup getTestDHGroup(int primeSize) {
        return switch (primeSize) {
            case 2048 -> DiffieHellmanGroup.ffdhe2048;
            case 3072 -> DiffieHellmanGroup.ffdhe3072;
            case 4096 -> DiffieHellmanGroup.ffdhe4096;
            default -> throw new RuntimeException("Test DH group not defined for " + primeSize);
        };
    }

    private static void removeFromDSigPolicy(String rule, List<String> algs) {
        String value = Security.getProperty("jdk.xml.dsig.secureValidationPolicy");
        value = Arrays.stream(value.split(",")).filter(v -> !v.contains(rule) || !SecurityUtils.anyMatch(v, algs)).collect(Collectors.joining(","));
        Security.setProperty("jdk.xml.dsig.secureValidationPolicy", value);
    }

    private static boolean anyMatch(String value, List<String> algs) {
        for (String alg : algs) {
            if (!value.contains(alg)) continue;
            return true;
        }
        return false;
    }

    public static void inspectTlsBuffer(ByteBuffer buffer) throws IOException {
        if (buffer == null || !buffer.hasRemaining()) {
            return;
        }
        ByteBuffer packet = buffer.slice();
        System.err.printf("---TLS Buffer Inspection. Bytes Remaining: %d---\n", packet.remaining());
        int i = 1;
        while (packet.position() < packet.limit()) {
            byte contentType = packet.get();
            byte majorVersion = packet.get();
            byte minorVersion = packet.get();
            int contentLen = SecurityUtils.getInt16(packet);
            System.err.printf("Flight %d: contentType: %d; majorVersion: %d; minorVersion: %d; contentLen: %d\n", i, (int)contentType, (int)majorVersion, (int)minorVersion, contentLen);
            packet.position(packet.position() + contentLen);
            ++i;
        }
    }

    public static int getInt16(ByteBuffer m) throws IOException {
        return (m.get() & 0xFF) << 8 | m.get() & 0xFF;
    }

    private SecurityUtils() {
    }

    private static enum KeySize {
        RSA(2048),
        DSA(2048),
        Ed25519(256),
        EC(256),
        DH(2048);

        private final int keySize;

        private KeySize(int keySize) {
            this.keySize = keySize;
        }

        public String toString() {
            return String.valueOf(this.keySize);
        }
    }
}

