/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.threaddump;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import jdk.test.lib.json.JSONValue;

public final class ThreadDump {
    private final ThreadContainer rootThreadContainer;
    private final Map<String, ThreadContainer> nameToThreadContainer;
    private final JSONValue threadDumpObj;

    private ThreadDump(ThreadContainer rootThreadContainer, Map<String, ThreadContainer> nameToThreadContainer, JSONValue threadDumpObj) {
        this.rootThreadContainer = rootThreadContainer;
        this.nameToThreadContainer = nameToThreadContainer;
        this.threadDumpObj = threadDumpObj;
    }

    private String getStringProperty(String propertyName) {
        JSONValue value = this.threadDumpObj.get(propertyName);
        return value != null ? value.asString() : null;
    }

    public long processId() {
        return Long.parseLong(this.getStringProperty("processId"));
    }

    public String time() {
        return this.getStringProperty("time");
    }

    public String runtimeVersion() {
        return this.getStringProperty("runtimeVersion");
    }

    public ThreadContainer rootThreadContainer() {
        return this.rootThreadContainer;
    }

    public Optional<ThreadContainer> findThreadContainer(String name) {
        ThreadContainer container = this.nameToThreadContainer.get(name);
        if (container == null) {
            container = this.nameToThreadContainer.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(name + "/")).map(e -> (ThreadContainer)e.getValue()).findAny().orElse(null);
        }
        return Optional.of(container);
    }

    public static ThreadDump parse(String json) {
        JSONValue threadDumpObj = JSONValue.parse(json).get("threadDump");
        LinkedHashMap<String, JSONValue> containerObjs = new LinkedHashMap<String, JSONValue>();
        JSONValue threadContainersObj = threadDumpObj.get("threadContainers");
        for (JSONValue containerObj : threadContainersObj.asArray()) {
            String name = containerObj.get("container").asString();
            containerObjs.put(name, containerObj);
        }
        ThreadContainer root = null;
        HashMap<String, ThreadContainer> map = new HashMap<String, ThreadContainer>();
        for (String name : containerObjs.keySet()) {
            JSONValue containerObj = (JSONValue)containerObjs.get(name);
            String parentName = containerObj.get("parent").asString();
            if (parentName == null) {
                root = new ThreadContainer(name, null, containerObj);
                map.put(name, root);
                continue;
            }
            ThreadContainer parent = (ThreadContainer)map.get(parentName);
            if (parent == null) {
                throw new RuntimeException("Thread container " + name + " found before " + parentName);
            }
            ThreadContainer container = new ThreadContainer(name, parent, containerObj);
            parent.addChild(container);
            map.put(name, container);
        }
        return new ThreadDump(root, map, threadDumpObj);
    }

    public static class ThreadContainer {
        private final String name;
        private final ThreadContainer parent;
        private final Set<ThreadContainer> children = new HashSet<ThreadContainer>();
        private final JSONValue containerObj;

        ThreadContainer(String name, ThreadContainer parent, JSONValue containerObj) {
            this.name = name;
            this.parent = parent;
            this.containerObj = containerObj;
        }

        void addChild(ThreadContainer container) {
            this.children.add(container);
        }

        private String getStringProperty(String propertyName) {
            JSONValue value = this.containerObj.get(propertyName);
            return value != null ? value.asString() : null;
        }

        public String name() {
            return this.name;
        }

        public OptionalLong owner() {
            String owner = this.getStringProperty("owner");
            return owner != null ? OptionalLong.of(Long.parseLong(owner)) : OptionalLong.empty();
        }

        public Optional<ThreadContainer> parent() {
            return Optional.ofNullable(this.parent);
        }

        public Stream<ThreadContainer> children() {
            return this.children.stream();
        }

        public Stream<ThreadInfo> threads() {
            JSONValue.JSONArray threadsObj = this.containerObj.get("threads").asArray();
            HashSet<ThreadInfo> threadInfos = new HashSet<ThreadInfo>();
            for (JSONValue threadObj : threadsObj) {
                threadInfos.add(new ThreadInfo(threadObj));
            }
            return threadInfos.stream();
        }

        public Optional<ThreadInfo> findThread(long tid) {
            return this.threads().filter(ti -> ti.tid() == tid).findAny();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadContainer) {
                ThreadContainer other = (ThreadContainer)obj;
                return this.name.equals(other.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class ThreadInfo {
        private final long tid;
        private final JSONValue threadObj;

        ThreadInfo(JSONValue threadObj) {
            this.tid = Long.parseLong(threadObj.get("tid").asString());
            this.threadObj = threadObj;
        }

        private String getStringProperty(String propertyName) {
            JSONValue value = this.threadObj.get(propertyName);
            return value != null ? value.asString() : null;
        }

        private String getStringProperty(String objectName, String propertyName) {
            JSONValue.JSONObject obj;
            JSONValue jSONValue = this.threadObj.get(objectName);
            if (jSONValue instanceof JSONValue.JSONObject && (jSONValue = (obj = (JSONValue.JSONObject)jSONValue).get(propertyName)) instanceof JSONValue) {
                JSONValue value = jSONValue;
                return value.asString();
            }
            return null;
        }

        public long tid() {
            return this.tid;
        }

        public String name() {
            return this.getStringProperty("name");
        }

        public String state() {
            return this.getStringProperty("state");
        }

        public boolean isVirtual() {
            String s = this.getStringProperty("virtual");
            return s != null ? Boolean.parseBoolean(s) : false;
        }

        public String parkBlocker() {
            return this.getStringProperty("parkBlocker", "object");
        }

        public String blockedOn() {
            return this.getStringProperty("blockedOn");
        }

        public String waitingOn() {
            return this.getStringProperty("waitingOn");
        }

        public Stream<String> stack() {
            JSONValue.JSONArray stackObj = this.threadObj.get("stack").asArray();
            ArrayList<String> stack = new ArrayList<String>();
            for (JSONValue steObject : stackObj) {
                stack.add(steObject.asString());
            }
            return stack.stream();
        }

        public Map<Integer, List<String>> ownedMonitors() {
            HashMap<Integer, List<String>> ownedMonitors = new HashMap<Integer, List<String>>();
            JSONValue monitorsOwnedObj = this.threadObj.get("monitorsOwned");
            if (monitorsOwnedObj != null) {
                for (JSONValue obj : monitorsOwnedObj.asArray()) {
                    int depth = Integer.parseInt(obj.get("depth").asString());
                    for (JSONValue lock : obj.get("locks").asArray()) {
                        ownedMonitors.computeIfAbsent(depth, n -> new ArrayList()).add(lock.asString());
                    }
                }
            }
            return ownedMonitors;
        }

        public OptionalLong carrier() {
            String s = this.getStringProperty("carrier");
            return s != null ? OptionalLong.of(Long.parseLong(s)) : OptionalLong.empty();
        }

        public int hashCode() {
            return Long.hashCode(this.tid);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ThreadInfo) {
                ThreadInfo other = (ThreadInfo)obj;
                return this.tid == other.tid;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("#");
            sb.append(this.tid);
            String name = this.name();
            if (name.length() > 0) {
                sb.append(",").append(name);
            }
            return sb.toString();
        }
    }
}

