/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.BitType;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.IntType;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicIntType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.utilities.Assert;

public class BasicBitType
extends BasicIntType
implements BitType {
    private Type underlyingType;
    private int sizeInBits;
    private int offset;

    public BasicBitType(Type underlyingType, int sizeInBits, int lsbOffset) {
        this(underlyingType, sizeInBits, lsbOffset, 0);
    }

    private BasicBitType(Type underlyingType, int sizeInBits, int lsbOffset, int cvAttributes) {
        super(null, 0, false, cvAttributes);
        this.underlyingType = underlyingType;
        this.sizeInBits = sizeInBits;
        this.offset = lsbOffset;
    }

    @Override
    public BitType asBit() {
        return this;
    }

    @Override
    public int getSize() {
        return this.underlyingType.getSize();
    }

    @Override
    public boolean isUnsigned() {
        if (this.underlyingType.isInt()) {
            return ((IntType)this.underlyingType).isUnsigned();
        }
        return false;
    }

    @Override
    public int getSizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.underlyingType = db.resolveType(this, this.underlyingType, listener, "resolving bit type");
        this.setName(this.underlyingType.getName());
        if (Assert.ASSERTS_ENABLED) {
            BasicType b = (BasicType)this.underlyingType;
            Assert.that(b.isLazy() || b.isInt(), "Underlying type of bitfield must be integer type (or unresolved due to error)");
        }
        return this;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
        long mask = BasicBitType.maskFor(this.sizeInBits);
        long val = a.getCIntegerAt(0L, this.getSize(), this.isUnsigned()) >> this.getOffset() & mask;
        if (!this.isUnsigned() && (val & BasicBitType.highBit(this.sizeInBits)) != 0L) {
            val |= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        v.doBit(f, val);
    }

    @Override
    protected Type createCVVariant(int cvAttributes) {
        return new BasicBitType(this.underlyingType, this.getSizeInBits(), this.getOffset(), cvAttributes);
    }

    @Override
    public void visit(TypeVisitor v) {
        v.doBitType(this);
    }

    private static long maskFor(int sizeInBits) {
        return (1 << sizeInBits) - 1;
    }

    private static long highBit(int sizeInBits) {
        return 1 << sizeInBits - 1;
    }
}

