/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Objects;

final class DateTimePrintContext {
    private TemporalAccessor temporal;
    private DateTimeFormatter formatter;
    private int optional;

    DateTimePrintContext(TemporalAccessor temporalAccessor, DateTimeFormatter dateTimeFormatter) {
        this.temporal = DateTimePrintContext.adjust(temporalAccessor, dateTimeFormatter);
        this.formatter = dateTimeFormatter;
    }

    private static TemporalAccessor adjust(final TemporalAccessor temporalAccessor, DateTimeFormatter dateTimeFormatter) {
        ChronoLocalDate chronoLocalDate;
        ZoneId zoneId;
        Chronology chronology;
        Chronology chronology2 = dateTimeFormatter.getChronology();
        ZoneId zoneId2 = dateTimeFormatter.getZone();
        if (chronology2 == null && zoneId2 == null) {
            return temporalAccessor;
        }
        Chronology chronology3 = temporalAccessor.query(TemporalQueries.chronology());
        ZoneId zoneId3 = temporalAccessor.query(TemporalQueries.zoneId());
        if (Objects.equals(chronology2, chronology3)) {
            chronology2 = null;
        }
        if (Objects.equals(zoneId2, zoneId3)) {
            zoneId2 = null;
        }
        if (chronology2 == null && zoneId2 == null) {
            return temporalAccessor;
        }
        Chronology chronology4 = chronology = chronology2 != null ? chronology2 : chronology3;
        if (zoneId2 != null) {
            if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                Chronology chronology5 = chronology != null ? chronology : IsoChronology.INSTANCE;
                return chronology5.zonedDateTime(Instant.from(temporalAccessor), zoneId2);
            }
            if (zoneId2.normalized() instanceof ZoneOffset && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS) && temporalAccessor.get(ChronoField.OFFSET_SECONDS) != zoneId2.getRules().getOffset(Instant.EPOCH).getTotalSeconds()) {
                throw new DateTimeException("Unable to apply override zone '" + zoneId2 + "' because the temporal object being formatted has a different offset but does not represent an instant: " + temporalAccessor);
            }
        }
        ZoneId zoneId4 = zoneId = zoneId2 != null ? zoneId2 : zoneId3;
        if (chronology2 != null) {
            if (temporalAccessor.isSupported(ChronoField.EPOCH_DAY)) {
                chronoLocalDate = chronology.date(temporalAccessor);
            } else {
                if (chronology2 != IsoChronology.INSTANCE || chronology3 != null) {
                    for (ChronoField chronoField : ChronoField.values()) {
                        if (!chronoField.isDateBased() || !temporalAccessor.isSupported(chronoField)) continue;
                        throw new DateTimeException("Unable to apply override chronology '" + chronology2 + "' because the temporal object being formatted contains date fields but does not represent a whole date: " + temporalAccessor);
                    }
                }
                chronoLocalDate = null;
            }
        } else {
            chronoLocalDate = null;
        }
        return new TemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField temporalField) {
                if (chronoLocalDate != null && temporalField.isDateBased()) {
                    return chronoLocalDate.isSupported(temporalField);
                }
                return temporalAccessor.isSupported(temporalField);
            }

            @Override
            public ValueRange range(TemporalField temporalField) {
                if (chronoLocalDate != null && temporalField.isDateBased()) {
                    return chronoLocalDate.range(temporalField);
                }
                return temporalAccessor.range(temporalField);
            }

            @Override
            public long getLong(TemporalField temporalField) {
                if (chronoLocalDate != null && temporalField.isDateBased()) {
                    return chronoLocalDate.getLong(temporalField);
                }
                return temporalAccessor.getLong(temporalField);
            }

            @Override
            public <R> R query(TemporalQuery<R> temporalQuery) {
                if (temporalQuery == TemporalQueries.chronology()) {
                    return (R)chronology;
                }
                if (temporalQuery == TemporalQueries.zoneId()) {
                    return (R)zoneId;
                }
                if (temporalQuery == TemporalQueries.precision()) {
                    return temporalAccessor.query(temporalQuery);
                }
                return temporalQuery.queryFrom(this);
            }
        };
    }

    TemporalAccessor getTemporal() {
        return this.temporal;
    }

    Locale getLocale() {
        return this.formatter.getLocale();
    }

    DecimalStyle getDecimalStyle() {
        return this.formatter.getDecimalStyle();
    }

    void startOptional() {
        ++this.optional;
    }

    void endOptional() {
        --this.optional;
    }

    <R> R getValue(TemporalQuery<R> temporalQuery) {
        R r = this.temporal.query(temporalQuery);
        if (r == null && this.optional == 0) {
            throw new DateTimeException("Unable to extract value: " + this.temporal.getClass());
        }
        return r;
    }

    Long getValue(TemporalField temporalField) {
        try {
            return this.temporal.getLong(temporalField);
        }
        catch (DateTimeException dateTimeException) {
            if (this.optional > 0) {
                return null;
            }
            throw dateTimeException;
        }
    }

    public String toString() {
        return this.temporal.toString();
    }
}

