/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;

abstract class GapVector
implements Serializable {
    private Object array;
    private int g0;
    private int g1;

    public GapVector() {
        this(10);
    }

    public GapVector(int n) {
        this.array = this.allocateArray(n);
        this.g0 = 0;
        this.g1 = n;
    }

    protected abstract Object allocateArray(int var1);

    protected abstract int getArrayLength();

    protected final Object getArray() {
        return this.array;
    }

    protected final int getGapStart() {
        return this.g0;
    }

    protected final int getGapEnd() {
        return this.g1;
    }

    protected void replace(int n, int n2, Object object, int n3) {
        int n4 = 0;
        if (n3 == 0) {
            this.close(n, n2);
            return;
        }
        if (n2 > n3) {
            this.close(n + n3, n2 - n3);
        } else {
            int n5 = n3 - n2;
            int n6 = this.open(n + n2, n5);
            System.arraycopy(object, n2, this.array, n6, n5);
            n3 = n2;
        }
        System.arraycopy(object, n4, this.array, n, n3);
    }

    void close(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = n + n2;
        int n4 = this.g1 - this.g0 + n2;
        if (n3 <= this.g0) {
            if (this.g0 != n3) {
                this.shiftGap(n3);
            }
            this.shiftGapStartDown(this.g0 - n2);
        } else if (n >= this.g0) {
            if (this.g0 != n) {
                this.shiftGap(n);
            }
            this.shiftGapEndUp(this.g0 + n4);
        } else {
            this.shiftGapStartDown(n);
            this.shiftGapEndUp(this.g0 + n4);
        }
    }

    int open(int n, int n2) {
        int n3 = this.g1 - this.g0;
        if (n2 == 0) {
            if (n > this.g0) {
                n += n3;
            }
            return n;
        }
        this.shiftGap(n);
        if (n2 >= n3) {
            this.shiftEnd(this.getArrayLength() - n3 + n2);
            n3 = this.g1 - this.g0;
        }
        this.g0 += n2;
        return n;
    }

    void resize(int n) {
        Object object = this.allocateArray(n);
        System.arraycopy(this.array, 0, object, 0, Math.min(n, this.getArrayLength()));
        this.array = object;
    }

    protected void shiftEnd(int n) {
        int n2 = this.getArrayLength();
        int n3 = this.g1;
        int n4 = n2 - n3;
        int n5 = this.getNewArraySize(n);
        int n6 = n5 - n4;
        this.resize(n5);
        this.g1 = n6;
        if (n4 != 0) {
            System.arraycopy(this.array, n3, this.array, n6, n4);
        }
    }

    int getNewArraySize(int n) {
        return (n + 1) * 2;
    }

    protected void shiftGap(int n) {
        if (n == this.g0) {
            return;
        }
        int n2 = this.g0;
        int n3 = n - n2;
        int n4 = this.g1;
        int n5 = n4 + n3;
        int n6 = n4 - n2;
        this.g0 = n;
        this.g1 = n5;
        if (n3 > 0) {
            System.arraycopy(this.array, n4, this.array, n2, n3);
        } else if (n3 < 0) {
            System.arraycopy(this.array, n, this.array, n5, -n3);
        }
    }

    protected void shiftGapStartDown(int n) {
        this.g0 = n;
    }

    protected void shiftGapEndUp(int n) {
        this.g1 = n;
    }
}

