/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.net.InetAddress;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;
import jdk.jfr.internal.instrument.JITypeMapping;

@JIInstrumentationTarget(value="java.net.SocketInputStream")
@JITypeMapping(from="jdk.jfr.internal.instrument.SocketInputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
final class SocketInputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketInputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    int read(byte[] byArray, int n, int n2, int n3) throws IOException {
        SocketReadEvent socketReadEvent = SocketReadEvent.EVENT.get();
        if (!socketReadEvent.isEnabled()) {
            return this.read(byArray, n, n2, n3);
        }
        int n4 = 0;
        try {
            socketReadEvent.begin();
            n4 = this.read(byArray, n, n2, n3);
        }
        finally {
            socketReadEvent.end();
            if (socketReadEvent.shouldCommit()) {
                String string = this.impl.address.toString();
                int n5 = string.lastIndexOf(47);
                socketReadEvent.host = string.substring(0, n5);
                socketReadEvent.address = string.substring(n5 + 1);
                socketReadEvent.port = this.impl.port;
                if (n4 < 0) {
                    socketReadEvent.endOfStream = true;
                } else {
                    socketReadEvent.bytesRead = n4;
                }
                socketReadEvent.timeout = n3;
                socketReadEvent.commit();
                socketReadEvent.reset();
            }
        }
        return n4;
    }

    void silenceFindBugsUnwrittenField(InetAddress inetAddress) {
        this.impl.address = inetAddress;
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }
}

