/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.util.Arrays;

public abstract class ObjectWriter {
    protected StringBuffer result = new StringBuffer();

    public static ObjectWriter make(boolean bl, int n, int n2) {
        if (bl) {
            return new IndentingObjectWriter(n, n2);
        }
        return new SimpleObjectWriter();
    }

    public abstract void startObject(Object var1);

    public abstract void startElement();

    public abstract void endElement();

    public abstract void endObject(String var1);

    public abstract void endObject();

    public String toString() {
        return this.result.toString();
    }

    public void append(boolean bl) {
        this.result.append(bl);
    }

    public void append(char c) {
        this.result.append(c);
    }

    public void append(short s) {
        this.result.append(s);
    }

    public void append(int n) {
        this.result.append(n);
    }

    public void append(long l) {
        this.result.append(l);
    }

    public void append(float f) {
        this.result.append(f);
    }

    public void append(double d) {
        this.result.append(d);
    }

    public void append(String string) {
        this.result.append(string);
    }

    protected ObjectWriter() {
    }

    protected void appendObjectHeader(Object object) {
        this.result.append(object.getClass().getName());
        this.result.append("<");
        this.result.append(System.identityHashCode(object));
        this.result.append(">");
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz != null) {
            this.result.append("[");
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                this.result.append(blArray.length);
                this.result.append("]");
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.result.append(byArray.length);
                this.result.append("]");
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.result.append(sArray.length);
                this.result.append("]");
            } else if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.result.append(nArray.length);
                this.result.append("]");
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.result.append(lArray.length);
                this.result.append("]");
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.result.append(cArray.length);
                this.result.append("]");
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.result.append(fArray.length);
                this.result.append("]");
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.result.append(dArray.length);
                this.result.append("]");
            } else {
                Object[] objectArray = (Object[])object;
                this.result.append(objectArray.length);
                this.result.append("]");
            }
        }
        this.result.append("(");
    }

    private static class SimpleObjectWriter
    extends ObjectWriter {
        private SimpleObjectWriter() {
        }

        @Override
        public void startObject(Object object) {
            this.appendObjectHeader(object);
            this.result.append(" ");
        }

        @Override
        public void startElement() {
            this.result.append(" ");
        }

        @Override
        public void endObject(String string) {
            this.result.append(string);
            this.result.append(")");
        }

        @Override
        public void endElement() {
        }

        @Override
        public void endObject() {
            this.result.append(")");
        }
    }

    private static class IndentingObjectWriter
    extends ObjectWriter {
        private int level;
        private int increment;

        public IndentingObjectWriter(int n, int n2) {
            this.level = n;
            this.increment = n2;
            this.startLine();
        }

        private void startLine() {
            char[] cArray = new char[this.level * this.increment];
            Arrays.fill(cArray, ' ');
            this.result.append(cArray);
        }

        @Override
        public void startObject(Object object) {
            this.appendObjectHeader(object);
            ++this.level;
        }

        @Override
        public void startElement() {
            this.result.append("\n");
            this.startLine();
        }

        @Override
        public void endElement() {
        }

        @Override
        public void endObject(String string) {
            --this.level;
            this.result.append(string);
            this.result.append(")");
        }

        @Override
        public void endObject() {
            --this.level;
            this.result.append("\n");
            this.startLine();
            this.result.append(")");
        }
    }
}

