/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.JarCompat;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.io.StreamByteBuffer;

public class TransformReplacer
implements Closeable {
    private static final Loader SKIP_INSTRUMENTATION = new Loader();
    private final ConcurrentMap<ProtectionDomain, Loader> loaders = new ConcurrentHashMap<ProtectionDomain, Loader>();
    private final TransformedClassPath classPath;
    private volatile boolean closed;

    public TransformReplacer(TransformedClassPath classPath) {
        this.classPath = classPath;
    }

    public byte @Nullable [] getInstrumentedClass(@Nullable String className, @Nullable ProtectionDomain protectionDomain) {
        this.ensureOpened();
        if (className == null || protectionDomain == null) {
            return null;
        }
        try {
            return this.getLoader(protectionDomain).loadTransformedClass(className);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private Loader getLoader(ProtectionDomain domain) {
        Loader transformLoader = (Loader)this.loaders.get(domain);
        if (transformLoader == null) {
            transformLoader = this.storeIfAbsent(domain, this.createLoaderForDomain(domain));
            if (this.closed) {
                IOUtils.closeQuietly((Closeable)transformLoader);
                this.ensureOpened();
            }
        }
        return transformLoader;
    }

    private Loader createLoaderForDomain(ProtectionDomain domain) {
        File transformedPath;
        File originalPath = TransformReplacer.getOriginalFile(domain);
        File file = transformedPath = originalPath != null ? this.classPath.findTransformedEntryFor(originalPath) : null;
        if (transformedPath == null) {
            return SKIP_INSTRUMENTATION;
        }
        if (transformedPath.isFile()) {
            return new JarLoader(originalPath, transformedPath);
        }
        if (transformedPath.isDirectory()) {
            return new DirectoryLoader(transformedPath);
        }
        throw new IllegalArgumentException("Cannot load transformed entry " + transformedPath.getAbsolutePath());
    }

    private Loader storeIfAbsent(ProtectionDomain domain, Loader newLoader) {
        Loader oldLoader = this.loaders.putIfAbsent(domain, newLoader);
        if (oldLoader != null) {
            IOUtils.closeQuietly((Closeable)newLoader);
            return oldLoader;
        }
        return newLoader;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Loader value : this.loaders.values()) {
            IOUtils.closeQuietly((Closeable)value);
        }
    }

    private void ensureOpened() {
        if (this.closed) {
            throw new IllegalStateException("Cannot load the transformed class, the replacer is closed");
        }
    }

    private static @Nullable File getOriginalFile(ProtectionDomain protectionDomain) {
        URL originalUrl;
        CodeSource cs = protectionDomain.getCodeSource();
        URL uRL = originalUrl = cs != null ? cs.getLocation() : null;
        if (originalUrl == null || !"file".equals(originalUrl.getProtocol())) {
            return null;
        }
        try {
            return new File(originalUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot parse file URL " + originalUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTransformed(JarFile jarFile) throws IOException {
        JarEntry entry = jarFile.getJarEntry(MarkerResource.RESOURCE_NAME);
        if (entry != null) {
            try (InputStream in = jarFile.getInputStream(entry);){
                boolean bl = MarkerResource.TRANSFORMED.equals((Object)MarkerResource.readFromStream(in));
                return bl;
            }
        }
        return false;
    }

    private static String classNameToPath(String className) {
        return className + ".class";
    }

    private static class Loader
    implements Closeable {
        private Loader() {
        }

        public byte @Nullable [] loadTransformedClass(String className) throws IOException {
            return null;
        }

        @Override
        public void close() {
        }
    }

    private class JarLoader
    extends Loader {
        private final File originalPath;
        private final File transformedJarPath;
        private @Nullable JarCompat jarFile;

        public JarLoader(File originalPath, File transformedJarPath) {
            this.originalPath = originalPath;
            this.transformedJarPath = transformedJarPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized byte @Nullable [] loadTransformedClass(String className) throws IOException {
            JarFile jarFile = this.getJarFileLocked();
            JarEntry classEntry = jarFile.getJarEntry(TransformReplacer.classNameToPath(className));
            if (classEntry == null) {
                return null;
            }
            try (InputStream classBytes = jarFile.getInputStream(classEntry);){
                byte[] byArray = StreamByteBuffer.of(classBytes).readAsByteArray();
                return byArray;
            }
        }

        @Override
        public synchronized void close() {
            IOUtils.closeQuietly((Closeable)this.jarFile);
        }

        private JarFile getJarFileLocked() throws IOException {
            TransformReplacer.this.ensureOpened();
            if (this.jarFile == null) {
                this.jarFile = JarCompat.open(this.transformedJarPath);
                if (this.jarFile.isMultiRelease() && !TransformReplacer.isTransformed(this.jarFile.getJarFile())) {
                    throw new GradleException(String.format("Cannot load multi-release JAR '%s' because it cannot be fully instrumented for Java %d by this version of Gradle. Please use a supported Java version.", this.originalPath.getAbsolutePath(), this.jarFile.javaRuntimeVersionUsed()));
                }
            }
            return this.jarFile.getJarFile();
        }
    }

    private static class DirectoryLoader
    extends Loader {
        private final File transformedPath;

        public DirectoryLoader(File transformedDirPath) {
            this.transformedPath = transformedDirPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte @Nullable [] loadTransformedClass(String className) throws IOException {
            File classFile = new File(this.transformedPath, TransformReplacer.classNameToPath(className));
            if (!classFile.exists()) {
                return null;
            }
            try (FileInputStream classBytes = new FileInputStream(classFile);){
                byte[] byArray = StreamByteBuffer.of(classBytes).readAsByteArray();
                return byArray;
            }
        }
    }

    public static enum MarkerResource {
        TRANSFORMED(new byte[0]),
        NOT_TRANSFORMED(new byte[]{78});

        public static final String RESOURCE_NAME;
        private final byte[] markerBody;

        private MarkerResource(byte[] markerBody) {
            this.markerBody = markerBody;
        }

        public static MarkerResource readFromStream(InputStream in) throws IOException {
            int readByte = in.read();
            if (readByte < 0) {
                return TRANSFORMED;
            }
            return NOT_TRANSFORMED;
        }

        public byte[] asBytes() {
            return this.markerBody;
        }

        static {
            RESOURCE_NAME = TransformReplacer.class.getName() + ".transformed";
        }
    }
}

