/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_29a6edd.core.internal.analysis;

import java.util.BitSet;
import java.util.Collection;
import org.jacoco.agent.rt.internal_29a6edd.asm.tree.AbstractInsnNode;
import org.jacoco.agent.rt.internal_29a6edd.core.analysis.ICounter;
import org.jacoco.agent.rt.internal_29a6edd.core.internal.analysis.CounterImpl;
import org.jacoco.agent.rt.internal_29a6edd.core.internal.analysis.filter.Replacements;

public class Instruction {
    private final int line;
    private int branches;
    private final BitSet coveredBranches;
    private Instruction predecessor;
    private int predecessorBranch;

    public Instruction(int line) {
        this.line = line;
        this.branches = 0;
        this.coveredBranches = new BitSet();
    }

    public void addBranch(Instruction target, int branch) {
        ++this.branches;
        target.predecessor = this;
        target.predecessorBranch = branch;
        if (!target.coveredBranches.isEmpty()) {
            Instruction.propagateExecutedBranch(this, branch);
        }
    }

    public void addBranch(boolean executed, int branch) {
        ++this.branches;
        if (executed) {
            Instruction.propagateExecutedBranch(this, branch);
        }
    }

    private static void propagateExecutedBranch(Instruction insn, int branch) {
        while (insn != null) {
            if (!insn.coveredBranches.isEmpty()) {
                insn.coveredBranches.set(branch);
                break;
            }
            insn.coveredBranches.set(branch);
            branch = insn.predecessorBranch;
            insn = insn.predecessor;
        }
    }

    public int getLine() {
        return this.line;
    }

    public Instruction merge(Instruction other) {
        Instruction result = new Instruction(this.line);
        result.branches = this.branches;
        result.coveredBranches.or(this.coveredBranches);
        result.coveredBranches.or(other.coveredBranches);
        return result;
    }

    public Instruction replaceBranches(Replacements replacements, Mapper mapper) {
        Instruction result = new Instruction(this.line);
        int branchIndex = 0;
        for (Collection<Replacements.InstructionBranch> newBranch : replacements.values()) {
            for (Replacements.InstructionBranch from : newBranch) {
                if (!mapper.apply((AbstractInsnNode)from.instruction).coveredBranches.get(from.branch)) continue;
                result.coveredBranches.set(branchIndex);
            }
            ++branchIndex;
        }
        result.branches = branchIndex;
        return result;
    }

    public ICounter getInstructionCounter() {
        return this.coveredBranches.isEmpty() ? CounterImpl.COUNTER_1_0 : CounterImpl.COUNTER_0_1;
    }

    public ICounter getBranchCounter() {
        if (this.branches < 2) {
            return CounterImpl.COUNTER_0_0;
        }
        int covered = this.coveredBranches.cardinality();
        return CounterImpl.getInstance(this.branches - covered, covered);
    }

    static interface Mapper {
        public Instruction apply(AbstractInsnNode var1);
    }
}

