/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.searcher;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.searcher.BaseFrameworkSearcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.junit.launcher.JUnit4TestFinder;

public class JUnit4TestSearcher
extends BaseFrameworkSearcher {
    private static final JUnit4TestFinder JUNIT4_TEST_FINDER = new JUnit4TestFinder();

    public JUnit4TestSearcher() {
        this.testMethodAnnotations = new String[]{"org.junit.Test", "org.junit.experimental.theories.Theory"};
    }

    @Override
    public TestKind getTestKind() {
        return TestKind.JUnit;
    }

    @Override
    public String getJdtTestKind() {
        return "org.eclipse.jdt.junit.loader.junit4";
    }

    @Override
    public boolean isTestMethod(IMethodBinding methodBinding) {
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isAbstract((int)modifiers) || Modifier.isStatic((int)modifiers) || !Modifier.isPublic((int)modifiers)) {
            return false;
        }
        if (methodBinding.isConstructor() || !"void".equals(methodBinding.getReturnType().getName())) {
            return false;
        }
        return this.findAnnotation(methodBinding.getAnnotations(), this.getTestMethodAnnotations());
    }

    @Override
    public boolean isTestClass(IType type) throws JavaModelException {
        return JUNIT4_TEST_FINDER.isTest(type);
    }

    @Override
    public Set<IType> findTestItemsInContainer(IJavaElement element, IProgressMonitor monitor) throws CoreException {
        HashSet<IType> types = new HashSet<IType>();
        try {
            JUNIT4_TEST_FINDER.findTestsInContainer(element, types, monitor);
        }
        catch (OperationCanceledException e) {
            return Collections.emptySet();
        }
        return types;
    }
}

