/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Arrays;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;

public class OpenableElementInfo
extends JavaElementInfo {
    protected volatile IJavaElement[] children = JavaElement.NO_ELEMENTS;
    protected IModuleDescription module;
    protected boolean isStructureKnown = false;
    protected Object[] nonJavaResources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int length = oldChildren.length;
        if (length == 0) {
            OpenableElementInfo openableElementInfo = this;
            synchronized (openableElementInfo) {
                if (oldChildren == this.children) {
                    this.children = new IJavaElement[]{child};
                } else {
                    this.addChild(child);
                }
            }
        }
        int i = 0;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                OpenableElementInfo openableElementInfo = this;
                synchronized (openableElementInfo) {
                    if (oldChildren == this.children) {
                        return;
                    }
                    this.addChild(child);
                    return;
                }
            }
            ++i;
        }
        IJavaElement[] newChildren = new IJavaElement[length + 1];
        System.arraycopy(oldChildren, 0, newChildren, 0, length);
        newChildren[length] = child;
        OpenableElementInfo openableElementInfo = this;
        synchronized (openableElementInfo) {
            if (oldChildren == this.children) {
                this.children = newChildren;
            } else {
                this.addChild(child);
            }
        }
    }

    @Override
    public IJavaElement[] getChildren() {
        return this.children;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                if (length == 1) {
                    OpenableElementInfo openableElementInfo = this;
                    synchronized (openableElementInfo) {
                        if (oldChildren != this.children) {
                            this.removeChild(child);
                            return;
                        }
                        this.children = JavaElement.NO_ELEMENTS;
                        break;
                    }
                }
                IJavaElement[] newChildren = new IJavaElement[length - 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, i);
                if (i < length - 1) {
                    System.arraycopy(oldChildren, i + 1, newChildren, i, length - 1 - i);
                }
                OpenableElementInfo openableElementInfo = this;
                synchronized (openableElementInfo) {
                    if (oldChildren != this.children) {
                        this.removeChild(child);
                        return;
                    }
                    this.children = newChildren;
                    break;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(IJavaElement[] children) {
        OpenableElementInfo openableElementInfo = this;
        synchronized (openableElementInfo) {
            this.children = children.length > 0 ? children : JavaElement.NO_ELEMENTS;
        }
    }

    public void setModule(IModuleDescription module) {
        this.module = module;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("isStructureKnown=");
        sb.append(this.isStructureKnown);
        sb.append(", ");
        if (this.module != null) {
            sb.append("module=");
            sb.append(this.module);
            sb.append(", ");
        }
        if (this.children != null) {
            sb.append("children=");
            sb.append(Arrays.toString(this.children));
            sb.append(", ");
        }
        if (this.nonJavaResources != null) {
            sb.append("nonJavaResources=");
            sb.append(Arrays.toString(this.nonJavaResources));
        }
        sb.append("]");
        return sb.toString();
    }

    public IModuleDescription getModule() {
        return this.module;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.isStructureKnown = newIsStructureKnown;
    }

    void setNonJavaResources(Object[] resources) {
        this.nonJavaResources = resources;
    }
}

