/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.JdtCoreDomPackagePrivateUtility;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtils;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMTypeDeclarationLocator;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeArgumentMatchingUtility;
import org.eclipse.jdt.internal.core.search.matching.TypeReferenceLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

public class DOMTypeReferenceLocator
extends DOMPatternLocator {
    private TypeReferenceLocator locator;
    private List<IJavaElement> foundElements = new ArrayList<IJavaElement>();
    private Set<Name> imports = new HashSet<Name>();
    private MatchLocator matchLocator = null;
    private String packageName;
    public static final int TYPE_PARAMS_MATCH = 1;
    public static final int TYPE_PARAMS_COUNT_MATCH = 2;
    public static final int TYPE_PARAMS_NO_MATCH = 3;

    public DOMTypeReferenceLocator(TypeReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    private boolean hasPackageDeclarationAncestor(ASTNode node) {
        if (node instanceof org.eclipse.jdt.core.dom.PackageDeclaration) {
            return true;
        }
        return node == null ? false : this.hasPackageDeclarationAncestor(node.getParent());
    }

    @Override
    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.match(node.getTypeName(), nodeSet, locator);
    }

    @Override
    public LocatorResponse match(Name name, NodeSetWrapper nodeSet, MatchLocator locator) {
        BreakStatement bs;
        LabeledStatement ls;
        this.matchLocator = locator;
        ASTNode aSTNode = name.getParent();
        if (aSTNode instanceof LabeledStatement && (ls = (LabeledStatement)aSTNode).getLabel() == name) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        aSTNode = name.getParent();
        if (aSTNode instanceof BreakStatement && (bs = (BreakStatement)aSTNode).getLabel() == name) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        if (name.getLocationInParent() == TypeParameter.NAME_PROPERTY) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        if (!DOMTypeReferenceLocator.matchFineGrain((ASTNode)name, this.locator.fineGrain())) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        if (this.locator.pattern.simpleName == null) {
            int v = this.locator.pattern.mustResolve ? 2 : 3;
            return DOMTypeReferenceLocator.toResponse(v, false);
        }
        if (name instanceof SimpleName) {
            QualifiedName qn3;
            SimpleName sn2 = (SimpleName)name;
            if (this.locator.pattern.qualification == null) {
                return DOMTypeReferenceLocator.toResponse(this.match(sn2, nodeSet));
            }
            ASTNode parent3 = name.getParent();
            if (!(parent3 instanceof QualifiedName)) {
                return DOMTypeReferenceLocator.toResponse(this.match(sn2, nodeSet));
            }
            if (parent3 instanceof QualifiedName && (qn3 = (QualifiedName)parent3).getQualifier() == name && this.match(sn2, nodeSet) == 2) {
                return DOMTypeReferenceLocator.toResponse(2);
            }
            if (this.locator.pattern.getMatchMode() == 0) {
                return DOMTypeReferenceLocator.toResponse(0);
            }
            if (this.match(sn2, nodeSet) == 2) {
                return DOMTypeReferenceLocator.toResponse(2);
            }
            return DOMTypeReferenceLocator.toResponse(0);
        }
        if (name instanceof QualifiedName) {
            QualifiedName qn2 = (QualifiedName)name;
            return DOMTypeReferenceLocator.toResponse(this.match(qn2, nodeSet));
        }
        return DOMTypeReferenceLocator.toResponse(0);
    }

    @Override
    public LocatorResponse match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        this.matchLocator = locator;
        if (!DOMTypeReferenceLocator.matchFineGrain(node, this.locator.fineGrain())) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)node;
            ASTNode aSTNode = node.getParent();
            if (aSTNode instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)aSTNode;
                if (enumConstantDecl.getAnonymousClassDeclaration() != null) {
                    if (this.locator.pattern.simpleName == null) {
                        int v = nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
                        return DOMTypeReferenceLocator.toResponse(v, true);
                    }
                    if (this.locator.matchesName(this.locator.pattern.simpleName, enumDeclaration.getName().getIdentifier().toCharArray())) {
                        int v = nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
                        return DOMTypeReferenceLocator.toResponse(v, true);
                    }
                }
            }
        }
        if (node instanceof ImportDeclaration) {
            ImportDeclaration id = (ImportDeclaration)node;
            Name n = id.getName();
            this.imports.add(n);
        }
        if (node instanceof org.eclipse.jdt.core.dom.PackageDeclaration) {
            org.eclipse.jdt.core.dom.PackageDeclaration pd = (org.eclipse.jdt.core.dom.PackageDeclaration)node;
            this.packageName = pd.getName().toString();
        }
        return DOMTypeReferenceLocator.toResponse(0);
    }

    private LocatorResponse matchTypeNodeReturnComponent(Type node, String qualifiedNameFromNode, String fqqn, int defaultLevel) {
        if (this.locator.matchesName(qualifiedNameFromNode.toCharArray(), fqqn.toCharArray())) {
            Type nodeToUse = node;
            boolean replacementFound = false;
            if (!this.preferParamaterizedNode() && node instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)node;
                nodeToUse = pt.getType();
                replacementFound = true;
            }
            Type replacedNode = replacementFound ? nodeToUse : null;
            int typeParamMatches = this.validateTypeParameters(node);
            if (typeParamMatches == 1) {
                return new LocatorResponse(defaultLevel, replacementFound, (ASTNode)replacedNode, false, false);
            }
            int ret = typeParamMatches == 2 ? 4 : 0;
            boolean isErasurePattern = this.isPatternErasureMatch();
            boolean isEquivPattern = this.isPatternEquivalentMatch();
            if (ret == 4 && !isErasurePattern && !isEquivPattern) {
                ret = 0;
            }
            return new LocatorResponse(ret, replacementFound, (ASTNode)replacedNode, false, false);
        }
        return null;
    }

    @Override
    public LocatorResponse match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int defaultLevel;
        this.matchLocator = locator;
        if (!DOMTypeReferenceLocator.matchFineGrain((ASTNode)node, this.locator.fineGrain())) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        int n = defaultLevel = this.locator.pattern.mustResolve ? 2 : 3;
        if (this.locator.pattern.simpleName == null) {
            int v = nodeSet.addMatch((ASTNode)node, defaultLevel);
            return DOMTypeReferenceLocator.toResponse(v, true);
        }
        String qualifiedNameFromNode = this.getQualifiedNameFromType(node);
        String simpleNameFromNode = this.getNameStringFromType(node);
        Object patternQualifiedString = null;
        if (qualifiedNameFromNode != null && this.locator.pattern.qualification != null) {
            String q1 = new String(this.locator.pattern.qualification);
            String sn1 = new String(this.locator.pattern.simpleName);
            patternQualifiedString = !q1.isEmpty() ? q1 + "." + sn1 : sn1;
            LocatorResponse r1 = this.matchTypeNodeReturnComponent(node, (String)patternQualifiedString, qualifiedNameFromNode, defaultLevel);
            if (r1 != null) {
                return r1;
            }
            if (qualifiedNameFromNode.endsWith((String)patternQualifiedString)) {
                String fqqn;
                String[] patternQualifiedStringSegments = ((String)patternQualifiedString).split("\\.");
                firstSegment = patternQualifiedStringSegments == null || patternQualifiedStringSegments.length == 0 ? null : patternQualifiedStringSegments[0];
                String fqqnImport = this.fqqnFromImport(firstSegment);
                if (fqqnImport != null && (r1 = this.matchTypeNodeReturnComponent(node, qualifiedNameFromNode, fqqn = fqqnImport + ((String)patternQualifiedString).substring(firstSegment.length()), defaultLevel)) != null) {
                    return r1;
                }
                String[] nodeQualifiedStringSegments = qualifiedNameFromNode.split("\\.");
                int patternLen = patternQualifiedStringSegments == null ? 0 : patternQualifiedStringSegments.length;
                for (int i = 1; i <= patternLen; ++i) {
                    String patternSegmentFromEnd = patternQualifiedStringSegments[patternLen - i];
                    String matchingNodeSegment = nodeQualifiedStringSegments[nodeQualifiedStringSegments.length - i];
                    if (patternSegmentFromEnd.equals(matchingNodeSegment)) continue;
                    return DOMTypeReferenceLocator.toResponse(0);
                }
            } else if (((String)patternQualifiedString).equals(qualifiedNameFromNode) || ((String)patternQualifiedString).endsWith("." + qualifiedNameFromNode)) {
                String fqqn;
                String[] qualifiedNameFromNodeStringSegments = qualifiedNameFromNode.split("\\.");
                firstSegment = qualifiedNameFromNodeStringSegments == null || qualifiedNameFromNodeStringSegments.length == 0 ? null : qualifiedNameFromNodeStringSegments[0];
                String fqqnImport = this.fqqnFromImport(firstSegment);
                if (fqqnImport != null && (r1 = this.matchTypeNodeReturnComponent(node, (String)patternQualifiedString, fqqn = fqqnImport + qualifiedNameFromNode.substring(firstSegment.length()), defaultLevel)) != null) {
                    return r1;
                }
                if (this.packageName != null && (r1 = this.matchTypeNodeReturnComponent(node, (String)patternQualifiedString, fqqn = this.packageName + "." + qualifiedNameFromNode, defaultLevel)) != null) {
                    return r1;
                }
            } else {
                String fqqn;
                String fqqn2;
                String firstNodeSegment;
                String[] qualifiedNameFromNodeSegments = qualifiedNameFromNode.split("\\.");
                String[] qualifiedNamePatternSegments = ((String)patternQualifiedString).split("\\.");
                String string = qualifiedNameFromNodeSegments == null ? null : (firstNodeSegment = qualifiedNameFromNodeSegments.length == 0 ? null : qualifiedNameFromNodeSegments[0]);
                String firstPatternSegment = qualifiedNamePatternSegments == null ? null : (qualifiedNamePatternSegments.length == 0 ? null : qualifiedNamePatternSegments[0]);
                String fqqnImportFromNode = this.fqqnFromImport(firstNodeSegment);
                if (fqqnImportFromNode != null && (r1 = this.matchTypeNodeReturnComponent(node, qualifiedNameFromNode, fqqn2 = fqqnImportFromNode + qualifiedNameFromNode.substring(firstNodeSegment.length()), defaultLevel)) != null) {
                    return r1;
                }
                String fqqnImportFromPattern = this.fqqnFromImport(firstPatternSegment);
                if (fqqnImportFromPattern != null && (r1 = this.matchTypeNodeReturnComponent(node, qualifiedNameFromNode, fqqn = fqqnImportFromPattern + ((String)patternQualifiedString).substring(firstPatternSegment.length()), defaultLevel)) != null) {
                    return r1;
                }
                return DOMTypeReferenceLocator.toResponse(0);
            }
        }
        if (simpleNameFromNode != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleNameFromNode.toCharArray())) {
            int level = this.locator.pattern.mustResolve || this.locator.pattern.qualification == null ? 2 : 3;
            int typeParamMatches = this.validateTypeParameters(node);
            if (typeParamMatches == 3) {
                level = 0;
            }
            if (typeParamMatches == 2) {
                level = 4;
            }
            if (this.isPatternExactMatch() && typeParamMatches == 3) {
                boolean nodeHasTypeArgs;
                List list;
                boolean patternHasTypeArgs = this.locator.pattern.hasTypeArguments();
                if (node instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)node;
                    list = pt.typeArguments();
                } else {
                    list = null;
                }
                List nodeTypeArgs = list;
                boolean bl = nodeHasTypeArgs = nodeTypeArgs != null && nodeTypeArgs.size() > 0;
                if (!patternHasTypeArgs && !nodeHasTypeArgs) {
                    return DOMTypeReferenceLocator.toResponse(level);
                }
                return new LocatorResponse(0, false, null, false, false);
            }
            boolean isErasurePattern = this.isPatternErasureMatch();
            boolean isEquivPattern = this.isPatternEquivalentMatch();
            if (level == 4 && !isErasurePattern && !isEquivPattern) {
                level = 0;
            }
            if (level != 0) {
                Name n2;
                if ((!this.preferParamaterizedNode() || this.patternPrefersSimpleName()) && (n2 = this.getSimpleNameNodeFromType(node)) != null) {
                    nodeSet.addMatch((ASTNode)n2, level);
                    return new LocatorResponse(level, true, (ASTNode)n2, true, true);
                }
                int v = nodeSet.addMatch((ASTNode)node, level);
                return DOMTypeReferenceLocator.toResponse(v, true);
            }
        }
        return DOMTypeReferenceLocator.toResponse(0);
    }

    private boolean patternPrefersSimpleName() {
        return false;
    }

    private boolean isPatternErasureMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x10) == 16;
    }

    private boolean isPatternEquivalentMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x20) == 32;
    }

    private boolean isPatternExactMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x40) == 64;
    }

    private int validateTypeParameters(Type node) {
        SimpleType st;
        boolean patternHasTypeArgs = this.locator.pattern.hasTypeArguments();
        boolean erasureMatch = this.isPatternErasureMatch();
        boolean equivMatch = this.isPatternEquivalentMatch();
        boolean exactMatch = this.isPatternExactMatch();
        if (patternHasTypeArgs && !erasureMatch && !equivMatch && !exactMatch) {
            return 3;
        }
        char[][][] fromPattern = this.locator.pattern.getTypeArguments();
        if (fromPattern == null) {
            return 1;
        }
        if (node instanceof SimpleType && ((st = (SimpleType)node).getName() instanceof QualifiedName || st.getName() instanceof SimpleName)) {
            if (!erasureMatch && !equivMatch) {
                for (int i = 0; i < fromPattern.length; ++i) {
                    if (fromPattern[i] != null && fromPattern[i].length == 0) continue;
                    return 3;
                }
            }
            return 1;
        }
        Type working = node;
        boolean done = false;
        int i = 0;
        for (i = 0; i < fromPattern.length && !done; ++i) {
            boolean emptyPatternParams;
            List list;
            char[][] thisLevelTypeParams = fromPattern[i];
            if (working instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)working;
                list = pt.typeArguments();
            } else {
                list = null;
            }
            List typeArgs = list;
            boolean bl = emptyPatternParams = thisLevelTypeParams == null || thisLevelTypeParams.length == 0;
            if (emptyPatternParams) {
                if (exactMatch && emptyPatternParams && typeArgs != null && typeArgs.size() > 0) {
                    return 3;
                }
            } else {
                if (typeArgs == null || typeArgs.size() != thisLevelTypeParams.length) {
                    return 3;
                }
                for (int j = 0; j < thisLevelTypeParams.length; ++j) {
                    boolean singleTypeArgMatches;
                    ASTNode argj = (ASTNode)typeArgs.get(j);
                    IBinding domBinding = DOMASTNodeUtils.getBinding(argj);
                    String patternSig = new String(thisLevelTypeParams[j]);
                    IBinding patternBinding = JdtCoreDomPackagePrivateUtility.findBindingForType((ASTNode)node, patternSig);
                    if (patternBinding == null) {
                        boolean plusOrMinus = patternSig.startsWith("+") || patternSig.startsWith("-");
                        String safePatternString = plusOrMinus ? patternSig.substring(1) : patternSig;
                        patternBinding = safePatternString.startsWith("Q") ? JdtCoreDomPackagePrivateUtility.findUnresolvedBindingForType((ASTNode)node, patternSig) : JdtCoreDomPackagePrivateUtility.findBindingForType((ASTNode)node, safePatternString);
                    }
                    if (singleTypeArgMatches = TypeArgumentMatchingUtility.validateSingleTypeArgMatches(exactMatch, patternSig, patternBinding, domBinding, (PatternLocator)this.locator)) continue;
                    return 2;
                }
            }
            if (working instanceof ParameterizedType) {
                ParameterizedType ptt = (ParameterizedType)working;
                working = ptt.getType();
            }
            if (working instanceof QualifiedType) {
                QualifiedType qtt = (QualifiedType)working;
                working = qtt.getQualifier();
            }
            if (!(working instanceof SimpleType)) continue;
            done = true;
        }
        for (int k = i; k < fromPattern.length; ++k) {
            if (fromPattern[k] == null || fromPattern[k].length == 0) continue;
            return 3;
        }
        return 1;
    }

    private String getQualifiedNameFromType(Type query) {
        if (query instanceof QualifiedType) {
            QualifiedType qtt = (QualifiedType)query;
            String qualString = this.getQualifiedNameFromType(qtt.getQualifier());
            String nameString = this.getNameStringFromType(query);
            return qualString == null || nameString == null ? null : qualString + "." + nameString;
        }
        if (query instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)query;
            return this.getQualifiedNameFromType(ptt.getType());
        }
        if (query instanceof SimpleType) {
            List types;
            SimpleType st = (SimpleType)query;
            String stName = st.getName().toString();
            if (stName.contains(".")) {
                return stName;
            }
            String fqqn = this.fqqnFromImport(stName);
            if (fqqn != null) {
                return fqqn;
            }
            org.eclipse.jdt.core.dom.CompilationUnit cu = this.findCompilationUnitAncestor((ASTNode)query);
            if (cu != null && (types = cu.types()) != null) {
                for (AbstractTypeDeclaration ad : types) {
                    if (!ad.getName().toString().equals(stName) || cu.getPackage() == null) continue;
                    String pkg = cu.getPackage().getName().toString();
                    return pkg + "." + stName;
                }
            }
        }
        return null;
    }

    private String getNameStringFromType(Type node) {
        Name name;
        Name nnode = this.getNameNodeFromType(node);
        if (nnode instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)nnode;
            name = qn.getName();
        } else {
            name = nnode;
        }
        nnode = name;
        return this.getNameStringFromNameObject(nnode);
    }

    private String getNameStringFromNameObject(Name nnode) {
        if (nnode instanceof SimpleName) {
            SimpleName name = (SimpleName)nnode;
            return name.getIdentifier();
        }
        return nnode == null ? null : nnode.toString();
    }

    private Name getSimpleNameNodeFromType(Type node) {
        Name name = this.getNameNodeFromType(node);
        if (name != null) {
            if (name instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)name;
                return qn.getName();
            }
            return name;
        }
        return null;
    }

    private Name getNameNodeFromType(Type node) {
        if (node instanceof SimpleType) {
            SimpleType simple = (SimpleType)node;
            return simple.getName();
        }
        if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            return qualified.getName();
        }
        if (node instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)node;
            return this.getNameNodeFromType(ptt.getType());
        }
        return null;
    }

    private Name getQualifierNameNodeFromType(Type node) {
        if (node instanceof SimpleType) {
            SimpleType simple = (SimpleType)node;
            return simple.getName();
        }
        if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            return this.getQualifierNameNodeFromType(qualified.getQualifier());
        }
        if (node instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)node;
            return this.getQualifierNameNodeFromType(ptt.getType());
        }
        return null;
    }

    private String fqqnFromImport(String firstSegment) {
        if (firstSegment == null) {
            return null;
        }
        for (Name n : this.imports) {
            if (n.isSimpleName() && n.toString().equals(firstSegment)) {
                return n.toString();
            }
            if (!n.isQualifiedName() || !n.toString().endsWith("." + firstSegment)) continue;
            return n.toString();
        }
        return null;
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        IPackageBinding pack;
        if (binding == null) {
            Name toAnalyse;
            if (node instanceof Name) {
                v0 = (Name)node;
            } else if (node instanceof SimpleType) {
                SimpleType st = (SimpleType)node;
                v0 = st.getName();
            } else {
                v0 = toAnalyse = null;
            }
            if (toAnalyse instanceof SimpleName) {
                SimpleName sn = (SimpleName)toAnalyse;
                int accuracy = this.resolveLevelForSimpleName(node, sn.getIdentifier());
                if (accuracy == 0) {
                    return DOMTypeReferenceLocator.toResponse(accuracy);
                }
                if (accuracy != -1) {
                    IResource r = null;
                    IJavaElement enclosing = DOMASTNodeUtils.getEnclosingJavaElement(node);
                    IJavaElement ancestor = enclosing == null ? null : enclosing.getAncestor(5);
                    try {
                        r = ancestor == null ? null : ancestor.getCorrespondingResource();
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    TypeReferenceMatch typeMatch = new TypeReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), locator.getParticipant(), r);
                    try {
                        this.reportSearchMatch(locator, node, (SearchMatch)typeMatch);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return DOMTypeReferenceLocator.toResponse(0);
                }
                return DOMTypeReferenceLocator.toResponse(1);
            }
            if (toAnalyse instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)toAnalyse;
                SearchPattern r = this.matchLocator.pattern;
                if (r instanceof TypeReferencePattern) {
                    TypeReferencePattern typePattern = (TypeReferencePattern)r;
                    if (!new String(typePattern.qualification).equals(qn.getQualifier().toString())) {
                        return DOMTypeReferenceLocator.toResponse(0);
                    }
                }
                return DOMTypeReferenceLocator.toResponse(1);
            }
            return DOMTypeReferenceLocator.toResponse(1);
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            if (!this.hasImportAncestor(node) && !DOMTypeDeclarationLocator.matchSearchForTypeSuffix(typeBinding, this.locator.pattern.typeSuffix)) {
                return DOMTypeReferenceLocator.toResponse(0);
            }
            if (this.hasImportAncestor(node) && !this.locator.isDeclarationOfReferencedTypesPattern) {
                return this.resolveLevelForImportBinding(node, typeBinding, locator);
            }
            boolean patternHasTypeArgs = this.locator.pattern.hasTypeArguments();
            boolean patternHasTypeParameters = this.locator.pattern.hasTypeParameters();
            boolean patternHasSignatures = this.locator.pattern.hasSignatures();
            boolean erasureMatch = this.isPatternErasureMatch();
            boolean equivMatch = this.isPatternEquivalentMatch();
            boolean exactMatch = this.isPatternExactMatch();
            if (patternHasTypeArgs && !erasureMatch && !equivMatch && !exactMatch) {
                return DOMTypeReferenceLocator.toResponse(0);
            }
            int v = this.resolveLevelForTypeBinding(node, typeBinding, locator);
            boolean prefersParameterized = this.preferParamaterizedNode();
            if (node instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)node;
                ParameterizedType n = prefersParameterized ? pt : pt.getType();
                return new LocatorResponse(v, n != pt, (ASTNode)n, false, false);
            }
            if (patternHasTypeArgs && !patternHasSignatures && !erasureMatch) {
                return DOMTypeReferenceLocator.toResponse(0);
            }
            return DOMTypeReferenceLocator.toResponse(v);
        }
        if (binding instanceof IPackageBinding && (pack = (IPackageBinding)binding).isRecovered() && node instanceof SimpleName) {
            SimpleName sn = (SimpleName)node;
            if (node.getLocationInParent() != QualifiedName.NAME_PROPERTY && !this.isInImport(node)) {
                if (this.locator.isDeclarationOfReferencedTypesPattern) {
                    return DOMTypeReferenceLocator.toResponse(0);
                }
                if (this.hasPackageDeclarationAncestor(node)) {
                    return DOMTypeReferenceLocator.toResponse(0);
                }
                String identifier = sn.getIdentifier();
                if (this.locator.matchesName(this.locator.pattern.simpleName, identifier.toCharArray())) {
                    return DOMTypeReferenceLocator.toResponse(1);
                }
            }
        }
        return DOMTypeReferenceLocator.toResponse(0);
    }

    private boolean isInImport(ASTNode node) {
        while (node != null) {
            if (node instanceof ImportDeclaration) {
                return true;
            }
            if (node instanceof org.eclipse.jdt.core.dom.PackageDeclaration) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private boolean preferParamaterizedNode() {
        boolean emptyTypeArgsPattern;
        int patternRule = this.locator.pattern.getMatchRule();
        boolean patternIsErasureMatch = this.isPatternErasureMatch();
        boolean patternIsEquivMatch = this.isPatternEquivalentMatch();
        boolean hasTypeArgs = this.locator.pattern.hasTypeArguments();
        boolean hasTypeParams = this.locator.pattern.hasTypeParameters();
        boolean bl = emptyTypeArgsPattern = this.locator.pattern.getTypeArguments() == null || this.locator.pattern.getTypeArguments().length == 0;
        if (patternIsEquivMatch) {
            return hasTypeArgs;
        }
        if (patternIsErasureMatch) {
            return false;
        }
        return this.locator.pattern.fineGrain == 0;
    }

    private LocatorResponse resolveLevelForImportBinding(ASTNode node, ITypeBinding typeBinding, MatchLocator locator2) {
        if (this.locator.pattern.hasTypeArguments() && !this.isEquivalentMatch && !this.isErasureMatch) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        if (this.locator.pattern.fineGrain != 0 && (this.locator.pattern.fineGrain & 0x8000) == 0) {
            return DOMTypeReferenceLocator.toResponse(0);
        }
        int newLevel = this.resolveLevelForTypeFQN(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding, null);
        return DOMTypeReferenceLocator.toResponse(newLevel);
    }

    private static boolean matchFineGrain(ASTNode node, int fineGrain) {
        ASTNode focusType;
        if (fineGrain == 0) {
            return true;
        }
        if ((fineGrain & 0x100000) != 0 && node.getLocationInParent() == InstanceofExpression.RIGHT_OPERAND_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x2000) != 0 && node.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x40) != 0 && node.getLocationInParent() == FieldDeclaration.TYPE_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x80) != 0 && node.getLocationInParent() == VariableDeclarationStatement.TYPE_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x100) != 0 && node.getLocationInParent() == SingleVariableDeclaration.TYPE_PROPERTY && node.getParent().getLocationInParent() == MethodDeclaration.PARAMETERS_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x200) != 0 && (node.getLocationInParent() == TypeDeclaration.SUPERCLASS_TYPE_PROPERTY || node.getLocationInParent() == TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY)) {
            return true;
        }
        if ((fineGrain & 0x400) != 0 && node.getLocationInParent() == MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x800) != 0) {
            ASTNode aSTNode = focusType = node.getLocationInParent() == IntersectionType.TYPES_PROPERTY ? node.getParent() : node;
            if (focusType.getLocationInParent() == CastExpression.TYPE_PROPERTY) {
                return true;
            }
        }
        if ((fineGrain & 0x1000) != 0) {
            ASTNode aSTNode = focusType = node.getLocationInParent() == UnionType.TYPES_PROPERTY ? node.getParent() : node;
            if (focusType.getLocationInParent() == SingleVariableDeclaration.TYPE_PROPERTY && focusType.getParent().getLocationInParent() == CatchClause.EXCEPTION_PROPERTY) {
                return true;
            }
        }
        if ((fineGrain & 0x4000) != 0 && (node.getLocationInParent() == MethodDeclaration.RETURN_TYPE2_PROPERTY || node.getLocationInParent() == AnnotationTypeMemberDeclaration.TYPE_PROPERTY)) {
            return true;
        }
        if ((fineGrain & 0x8000) != 0 && node.getLocationInParent() == ImportDeclaration.NAME_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x20000) != 0 && (node.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY || node.getLocationInParent() == MethodInvocation.TYPE_ARGUMENTS_PROPERTY)) {
            return true;
        }
        if ((fineGrain & 0x40000) != 0 && node.getLocationInParent() == TypeParameter.TYPE_BOUNDS_PROPERTY) {
            return true;
        }
        if ((fineGrain & 0x80000) != 0 && (node.getLocationInParent() == WildcardType.BOUND_PROPERTY || node.getLocationInParent() == WildcardType.UPPER_BOUND_PROPERTY)) {
            return true;
        }
        if ((fineGrain & 0x10000) != 0 && Set.of(NormalAnnotation.TYPE_NAME_PROPERTY, MarkerAnnotation.TYPE_NAME_PROPERTY, SingleMemberAnnotation.TYPE_NAME_PROPERTY).contains(node.getLocationInParent())) {
            return true;
        }
        return (fineGrain & 0x20000000) != 0 && node.getLocationInParent() == TypeDeclaration.PERMITS_TYPES_PROPERTY;
    }

    private int resolveLevelForSimpleName(ASTNode node, String simpleNameNeedle) {
        if (!simpleNameNeedle.contains(".") && this.locator.pattern.qualification != null && this.locator.pattern.qualification.length > 0) {
            for (Name id : this.imports) {
                QualifiedName qn;
                if (!(id instanceof QualifiedName) || !(qn = (QualifiedName)id).getName().toString().equals(simpleNameNeedle)) continue;
                char[] qualifiedPattern = this.locator.getQualifiedPattern(this.locator.pattern.simpleName, this.locator.pattern.qualification);
                int level3 = this.resolveLevelForTypeSourceName(qualifiedPattern, qn.toString().toCharArray(), null);
                if (level3 == 3) {
                    return 1;
                }
                return 1;
            }
        } else if (this.locator.pattern.qualification == null || this.locator.pattern.qualification.length == 0) {
            for (Name id : this.imports) {
                QualifiedName qn;
                if (!(id instanceof QualifiedName) || !(qn = (QualifiedName)id).getName().toString().equals(simpleNameNeedle)) continue;
                return 0;
            }
            org.eclipse.jdt.core.dom.CompilationUnit unit = (org.eclipse.jdt.core.dom.CompilationUnit)DOMCompletionUtils.findParent(node, new int[]{15});
            if (unit.getPackage() != null && !unit.getPackage().getName().toString().isEmpty()) {
                return 0;
            }
        }
        return -1;
    }

    private int resolveLevelForTypeBinding(ASTNode node, ITypeBinding typeBinding, MatchLocator locator) {
        TypeReferencePattern tp;
        SearchPattern searchPattern;
        TypeReferencePattern trp = locator != null && (searchPattern = locator.pattern) instanceof TypeReferencePattern ? (tp = (TypeReferencePattern)searchPattern) : null;
        TypeReferencePattern typeReferencePattern = trp = trp == null && this.locator != null ? this.locator.pattern : trp;
        if (trp == null) {
            return 0;
        }
        if (trp.focus != null) {
            IJavaElement je = typeBinding.getJavaElement();
            return Objects.equals(je, locator.pattern.focus) ? 3 : 0;
        }
        DOMPatternLocator.IImportDiscovery importDiscovery = new DOMPatternLocator.IImportDiscovery(this){
            final /* synthetic */ DOMTypeReferenceLocator this$0;
            {
                DOMTypeReferenceLocator dOMTypeReferenceLocator = this$0;
                Objects.requireNonNull(dOMTypeReferenceLocator);
                this.this$0 = dOMTypeReferenceLocator;
            }

            @Override
            public String findImportForString(String s) {
                return this.this$0.fqqnFromImport(s);
            }
        };
        int newLevel = this.resolveLevelForTypeFQN(trp.simpleName, trp.qualification, typeBinding, importDiscovery);
        if (this.locator != null && this.locator.isDeclarationOfReferencedTypesPattern) {
            return this.resolveLevelForTypeBindingDeclarationOfReferencedTypes(typeBinding, node, newLevel, locator);
        }
        if (newLevel == 0) {
            String qualNameFromBinding = typeBinding.getQualifiedName();
            int simpleNameMatch = this.resolveLevelForSimpleName(node, qualNameFromBinding);
            if (simpleNameMatch != -1) {
                return simpleNameMatch;
            }
            if (node instanceof Type) {
                Type t = (Type)node;
                String qualifiedNameFromNode = this.getQualifiedNameFromType(t);
                char[] qualifiedPattern = this.getQualifiedPattern(trp.simpleName, trp.qualification);
                if (qualifiedNameFromNode != null && qualNameFromBinding.endsWith(qualifiedNameFromNode)) {
                    int level3 = this.resolveLevelForTypeSourceName(qualifiedPattern, qualifiedNameFromNode.toCharArray(), typeBinding);
                    if (level3 != 0) {
                        return level3;
                    }
                } else {
                    String suffix;
                    int level3;
                    String pkg;
                    org.eclipse.jdt.core.dom.CompilationUnit cu = this.findCompilationUnitAncestor(node);
                    String string = pkg = cu.getPackage() == null ? null : cu.getPackage().getName().toString();
                    if (pkg != null && qualNameFromBinding.startsWith(pkg + ".") && (level3 = this.resolveLevelForTypeSourceName(qualifiedPattern, (suffix = qualNameFromBinding.substring(pkg.length() + 1)).toCharArray(), typeBinding)) != 0) {
                        return level3;
                    }
                }
            }
        }
        if (newLevel == 3 && trp.hasTypeArguments()) {
            return this.resolveLevelForTypeBindingWithTypeArguments(typeBinding, node, locator);
        }
        return newLevel;
    }

    private int resolveLevelForTypeBindingWithTypeArguments(ITypeBinding typeBinding, ASTNode node, MatchLocator locator2) {
        int bindingTypeParamsLength;
        boolean patternHasTypeArgs = this.locator.pattern.hasTypeArguments();
        boolean patternHasTypeParams = this.locator.pattern.hasTypeParameters();
        boolean patternHasTypeSignatures = !patternHasTypeArgs || !patternHasTypeParams;
        char[][][] patternTypeArgArray = this.locator.pattern.getTypeArguments();
        int patternTypeArgsLength = patternTypeArgArray == null ? -1 : (patternTypeArgArray[0] == null ? -1 : patternTypeArgArray[0].length);
        boolean bindingIsRaw = typeBinding.isRawType();
        boolean bindingIsGeneric = typeBinding.isGenericType();
        boolean bindingIsParameterized = typeBinding.isParameterizedType();
        int patternRule = this.locator.pattern.getMatchRule();
        boolean patternIsErasureMatch = this.isPatternErasureMatch();
        boolean patternIsEquivMatch = this.isPatternEquivalentMatch();
        ITypeBinding[] bindingArgs = typeBinding.getTypeArguments();
        ITypeBinding[] bindingParams = typeBinding.getTypeParameters();
        int bindingTypeArgsLength = bindingArgs == null ? -1 : bindingArgs.length;
        int n = bindingTypeParamsLength = bindingParams == null ? -1 : bindingParams.length;
        if (patternTypeArgsLength == bindingTypeArgsLength) {
            Type t;
            Type type = t = node instanceof Type ? (Type)node : null;
            if (t != null) {
                int typeArgsValidation = this.validateTypeParameters(t);
                if (typeArgsValidation == 1) {
                    if (!patternHasTypeSignatures) {
                        return 4;
                    }
                    return 3;
                }
                if (typeArgsValidation == 2 || typeArgsValidation == 3) {
                    if (this.isPatternExactMatch()) {
                        return 0;
                    }
                    return 4;
                }
            }
            if (!bindingIsRaw && patternHasTypeArgs) {
                return 4;
            }
            return 3;
        }
        if (patternTypeArgsLength != 0 && bindingIsGeneric && patternTypeArgsLength != bindingTypeParamsLength) {
            return 0;
        }
        if (patternTypeArgsLength == 0) {
            return 3;
        }
        if (bindingTypeArgsLength == 0) {
            if (patternIsEquivMatch && bindingIsRaw) {
                return 3;
            }
            if (!(bindingIsRaw || patternIsEquivMatch || patternIsErasureMatch)) {
                return 0;
            }
            if (!patternIsEquivMatch || bindingIsRaw) {
                return 3;
            }
        }
        return 0;
    }

    private int resolveLevelForTypeBindingDeclarationOfReferencedTypes(ITypeBinding typeBinding, ASTNode node, int newLevel, MatchLocator locator) {
        IJavaElement je;
        IJavaElement enclosing = ((DeclarationOfReferencedTypesPattern)this.locator.pattern).enclosingElement;
        ITypeBinding t2 = typeBinding.getTypeDeclaration();
        IJavaElement iJavaElement = je = t2 == null ? null : t2.getJavaElement();
        if (je != null && !this.foundElements.contains(je) && DOMASTNodeUtils.isWithinRange(node, enclosing)) {
            ISourceRange rangeToUse;
            IJavaElement iJavaElement2;
            ISourceReference sr = je instanceof ISourceReference ? (ISourceReference)je : null;
            IResource r = je.getResource();
            boolean isExternal = false;
            if (r == null && (iJavaElement2 = je.getAncestor(3)) instanceof JarPackageFragmentRoot) {
                JarPackageFragmentRoot jpfRoot = (JarPackageFragmentRoot)iJavaElement2;
                isExternal = true;
            }
            ISourceRange srg = null;
            ISourceRange nameRange = null;
            try {
                srg = sr.getSourceRange();
                nameRange = sr.getNameRange();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ISourceRange iSourceRange = rangeToUse = nameRange == null ? srg : nameRange;
            if (rangeToUse != null && (r != null || isExternal)) {
                TypeDeclarationMatch tdm = new TypeDeclarationMatch(je, newLevel, rangeToUse.getOffset(), rangeToUse.getLength(), locator.getParticipant(), r);
                try {
                    super.reportSearchMatch(locator, node, (SearchMatch)tdm);
                    this.foundElements.add(je);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    private org.eclipse.jdt.core.dom.CompilationUnit findCU(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            org.eclipse.jdt.core.dom.CompilationUnit cu = (org.eclipse.jdt.core.dom.CompilationUnit)node;
            return cu;
        }
        return this.findCU(node.getParent());
    }

    public int match(SimpleName name, NodeSetWrapper nodeSet) {
        String simpleName = name.getIdentifier();
        return simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    public int match(QualifiedName name, NodeSetWrapper nodeSet) {
        String desiredQualifier;
        String simpleName = name.getName().getIdentifier();
        String qualifier = name.getQualifier().toString();
        if (this.locator.pattern.qualification == null) {
            return 0;
        }
        if (qualifier != null && !qualifier.equals(desiredQualifier = new String(this.locator.pattern.qualification))) {
            return 0;
        }
        return simpleName != null && this.locator.matchesName(this.locator.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    protected int resolveLevelForType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            if (this.locator.pattern.typeSuffix != '\u0000') {
                return 1;
            }
        } else {
            switch (this.locator.pattern.typeSuffix) {
                case 'C': {
                    if (typeBinding.isClass()) break;
                    return 0;
                }
                case '\n': {
                    if (typeBinding.isClass() || typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\t': {
                    if (typeBinding.isClass() || typeBinding.isEnum()) break;
                    return 0;
                }
                case 'I': {
                    if (typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\u000b': {
                    if (typeBinding.isInterface() || typeBinding.isAnnotation()) break;
                    return 0;
                }
                case 'E': {
                    if (typeBinding.isEnum()) break;
                    return 0;
                }
                case 'A': {
                    if (typeBinding.isAnnotation()) break;
                    return 0;
                }
            }
        }
        return this.resolveLevelForType(this.locator.pattern.simpleName, this.locator.pattern.qualification, typeBinding);
    }

    private boolean hasImportAncestor(ASTNode node) {
        for (ASTNode working = node; working != null; working = working.getParent()) {
            if (!(working instanceof ImportDeclaration)) continue;
            return true;
        }
        return false;
    }

    private org.eclipse.jdt.core.dom.CompilationUnit findCompilationUnitAncestor(ASTNode node) {
        for (ASTNode working = node; working != null; working = working.getParent()) {
            if (!(working instanceof org.eclipse.jdt.core.dom.CompilationUnit)) continue;
            org.eclipse.jdt.core.dom.CompilationUnit wk = (org.eclipse.jdt.core.dom.CompilationUnit)working;
            return wk;
        }
        return null;
    }

    @Override
    public void reportSearchMatch(MatchLocator locator, ASTNode node, SearchMatch match) throws CoreException {
        ClassFileWorkingCopy wc;
        IImportDeclaration decl;
        IJavaElement iJavaElement;
        CompilationUnit unit;
        boolean report;
        IResource resource = match.getResource();
        if (resource == null) {
            return;
        }
        boolean bl = report = this.isErasureMatch && match.isErasure() || this.isEquivalentMatch && match.isEquivalent() || match.isExact();
        if (!report) {
            return;
        }
        this.updateMatchPositions(node, match);
        this.updateMatchRule(node, match);
        boolean bl2 = report = this.isErasureMatch && match.isErasure() || this.isEquivalentMatch && match.isEquivalent() || match.isExact();
        if (!report) {
            return;
        }
        Object object = match.getElement();
        if (object instanceof CompilationUnit && (unit = (CompilationUnit)object).getPackageName() != null) {
            String pkgName = CharOperation.toString((char[][])unit.getPackageName());
            PackageDeclaration element = unit.getPackageDeclaration(pkgName);
            match.setElement((Object)element);
        }
        if (object instanceof IImportDeclaration && (iJavaElement = (decl = (IImportDeclaration)object).getAncestor(5)) instanceof ClassFileWorkingCopy && (wc = (ClassFileWorkingCopy)iJavaElement).getTypes().length == 1) {
            match.setElement((Object)wc.getTypes()[0]);
        }
        super.reportSearchMatch(locator, node, match);
    }

    private void updateMatchRule(ASTNode node, SearchMatch match) {
        int n;
        int patternTypeArgsLength;
        if (this.hasImportAncestor(node)) {
            return;
        }
        int matchRule = match.getRule();
        char[][][] fromPattern = this.locator.pattern.getTypeArguments();
        int n2 = fromPattern == null || fromPattern.length == 0 || fromPattern[0] == null ? 0 : (patternTypeArgsLength = fromPattern.length <= 0 ? 0 : fromPattern[0].length);
        if (node instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)node;
            n = ptt.typeArguments().size();
        } else {
            n = 0;
        }
        int typeArgumentsLength = n;
        boolean hasTypeParameters = this.locator.pattern.hasTypeParameters();
        if (match.isRaw() && patternTypeArgsLength != 0) {
            matchRule &= 0xFFFFFFBF;
        }
        if (hasTypeParameters) {
            matchRule = 16;
        }
        if (patternTypeArgsLength == typeArgumentsLength) {
            if (!match.isRaw() && hasTypeParameters) {
                match.setRule(16);
            }
        } else if (patternTypeArgsLength == 0) {
            if (!match.isRaw() || hasTypeParameters) {
                match.setRule(matchRule & 0xFFFFFFBF);
            }
        } else if (typeArgumentsLength == 0) {
            match.setRule(matchRule & 0xFFFFFFBF);
        } else {
            match.setRule(0);
            return;
        }
        if (fromPattern == null || fromPattern.length == 0 || fromPattern[0] == null) {
            match.setRule(matchRule);
        }
    }

    private void updateMatchPositions(ASTNode node, SearchMatch match) {
        ASTNode replacementNodeForStartPosition = null;
        ASTNode toCheck = node;
        if (node instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)node;
            toCheck = ptt.getType();
        }
        if (toCheck instanceof QualifiedType) {
            QualifiedType qtt = (QualifiedType)toCheck;
            replacementNodeForStartPosition = this.findNodeMatchingPatternQualifier(qtt.getQualifier());
        } else if (toCheck instanceof SimpleType) {
            SimpleType st = (SimpleType)toCheck;
            replacementNodeForStartPosition = this.findNodeMatchingPatternQualifier((Type)st);
        }
        if (replacementNodeForStartPosition != null) {
            int matchStart = match.getOffset();
            int matchEnd = matchStart + match.getLength();
            int newStart = replacementNodeForStartPosition.getStartPosition();
            int newLength = matchEnd - newStart;
            match.setOffset(newStart);
            match.setLength(newLength);
        }
        if (this.locator.pattern.simpleName == null) {
            return;
        }
        ASTNode working = replacementNodeForStartPosition != null ? replacementNodeForStartPosition : node;
        int trimQualifierStart = this.findTrimQualifierStart(working);
        if (trimQualifierStart != -1) {
            int matchStart = match.getOffset();
            int matchEnd = matchStart + match.getLength();
            int newStart = trimQualifierStart;
            int newLength = matchEnd - newStart;
            match.setOffset(newStart);
            match.setLength(newLength);
        }
    }

    private int findTrimQualifierStart(ASTNode working) {
        Type workingType;
        Name n1;
        String needle;
        String string = needle = this.locator.pattern.qualification == null ? null : new String(this.locator.pattern.qualification);
        if (needle == null && working instanceof Type && (n1 = this.getSimpleNameNodeFromType(workingType = (Type)working)) != null) {
            return n1.getStartPosition();
        }
        if (needle != null && working instanceof Type) {
            Name name;
            workingType = (Type)working;
            Name n = this.getQualifierNameNodeFromType(workingType);
            if (n instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)n;
                name = qn.getName();
            } else {
                name = n;
            }
            n = name;
            String asString = this.getNameStringFromNameObject(n);
            if (asString != null && this.locator.matchesName(this.locator.pattern.qualification, asString.toCharArray())) {
                return n.getStartPosition();
            }
        }
        return -1;
    }

    private ASTNode findNodeMatchingPatternQualifier(Type qualifier) {
        String needle;
        if (qualifier instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)qualifier;
            return this.findNodeMatchingPatternQualifier(pt.getType());
        }
        final Name[] retNode = new Name[]{null};
        String string = needle = this.locator.pattern.qualification == null ? null : new String(this.locator.pattern.qualification);
        if (needle != null) {
            qualifier.accept(new ASTVisitor(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean visit(QualifiedName node) {
                    if (node.getName().toString().equals(needle)) {
                        retNode[0] = node.getName();
                    }
                    return retNode[0] == null;
                }

                public boolean visit(SimpleName node) {
                    if (node.toString().equals(needle)) {
                        retNode[0] = node;
                    }
                    return retNode[0] == null;
                }

                public boolean visit(ParameterizedType node) {
                    node.getType().accept((ASTVisitor)this);
                    return false;
                }
            });
        }
        return retNode[0];
    }
}

