/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.maven;

import com.microsoft.java.maven.ArtifactResult;
import com.microsoft.java.maven.ClassSearcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArtifactSearcher {
    private static ClassSearcher classSearcher = null;
    private static final String contextId = "indexer";
    private static final String repositoryId = "repo";
    private static String extensionPath;
    private static final String index = "index";
    private static final String artifactUsage = "ArtifactUsage.json";

    public static void initialize(String path) {
        extensionPath = path;
    }

    public static List<ArtifactResult> searchByClassName(String className, IProgressMonitor monitor) {
        if (classSearcher == null) {
            ArtifactSearcher.constructContext();
        }
        try {
            className = className.toLowerCase();
            return classSearcher.searchByClassName(className);
        }
        catch (Exception exception) {
            return new ArrayList<ArtifactResult>();
        }
    }

    public static List<ArtifactResult> searchByIdentifier(String groupId, String artifactId, IProgressMonitor monitor) {
        if (classSearcher == null) {
            ArtifactSearcher.constructContext();
        }
        try {
            return classSearcher.searchByIdentifier(groupId, artifactId);
        }
        catch (Exception exception) {
            return new ArrayList<ArtifactResult>();
        }
    }

    public static Boolean controlIndexerContext(Boolean controlParam, IProgressMonitor monitor) {
        if (classSearcher == null) {
            return true;
        }
        return classSearcher.controlIndexerContext(controlParam);
    }

    private static void constructContext() {
        try {
            String indexPath = Paths.get(extensionPath, index).toString();
            String artifactUsagePath = Paths.get(extensionPath, artifactUsage).toString();
            classSearcher = new ClassSearcher(contextId, repositoryId, indexPath, artifactUsagePath);
        }
        catch (Exception e) {
            classSearcher = null;
            e.printStackTrace();
        }
    }
}

