/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.launch.SupportedLaunchConfigType;
import org.eclipse.buildship.core.internal.util.classpath.ClasspathUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public abstract class LaunchConfigurationScope {
    public static final LaunchConfigurationScope INCLUDE_ALL = new IncludeAllLaunchConfigurationScope();

    public abstract boolean isEntryIncluded(IClasspathEntry var1);

    public static LaunchConfigurationScope from(ILaunchConfiguration configuration) {
        HashSet result = Sets.newHashSet();
        try {
            Set<IPackageFragmentRoot> soureFolders = SupportedLaunchConfigType.collectSourceFolders(configuration);
            for (IPackageFragmentRoot sourceFolder : soureFolders) {
                Optional<Set<String>> scope = ClasspathUtils.scopesFor(sourceFolder.getRawClasspathEntry());
                if (!scope.isPresent()) {
                    return INCLUDE_ALL;
                }
                result.addAll((Collection)scope.get());
            }
            return new FilteringLaunchConfigurationScope(result);
        }
        catch (CoreException e) {
            CorePlugin.logger().warn("Cannot collect dependency scope information for launch configuration " + configuration.getName(), e);
            return INCLUDE_ALL;
        }
    }

    private static final class FilteringLaunchConfigurationScope
    extends LaunchConfigurationScope {
        private final Set<String> scopes;

        public FilteringLaunchConfigurationScope(Set<String> scopes) {
            this.scopes = scopes;
        }

        @Override
        public boolean isEntryIncluded(IClasspathEntry entry) {
            if (this.scopes == null || this.scopes.isEmpty()) {
                return true;
            }
            Optional<Set<String>> entryUsedByScopes = ClasspathUtils.usedByScopesFor(entry);
            if (!entryUsedByScopes.isPresent() || entryUsedByScopes.get().isEmpty()) {
                return true;
            }
            return !Sets.intersection(this.scopes, entryUsedByScopes.get()).isEmpty();
        }
    }

    private static final class IncludeAllLaunchConfigurationScope
    extends LaunchConfigurationScope {
        private IncludeAllLaunchConfigurationScope() {
        }

        @Override
        public boolean isEntryIncluded(IClasspathEntry entry) {
            return true;
        }
    }
}

