/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ForLoops;
import org.eclipse.jdt.internal.corext.dom.VarDefinitionsUsesVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class AddAllCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    public AddAllCleanUpCore() {
        this(Collections.emptyMap());
    }

    public AddAllCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.add_all");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.add_all")) {
            return new String[]{MultiFixMessages.AddAllCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.add_all")) {
            return "outputList.addAll(inputList);\n\n\n";
        }
        return "for (int i = 0; i < inputList.size(); i++) {\n    outputList.add(inputList.get(i));\n}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.add_all")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(EnhancedForStatement node) {
                MethodInvocation methodInvocation = ASTNodes.asExpression(node.getBody(), MethodInvocation.class);
                IVariableBinding foreachVariable = node.getParameter().resolveBinding();
                if (methodInvocation != null && methodInvocation.arguments().size() == 1 && this.getVariableUseCount(foreachVariable, node.getBody()) == 1) {
                    Expression iterable = node.getExpression();
                    Expression argument = (Expression)methodInvocation.arguments().get(0);
                    if (ASTNodes.instanceOf(iterable, Collection.class.getCanonicalName())) {
                        if (ASTNodes.isSameLocalVariable((VariableDeclaration)node.getParameter(), argument)) {
                            return this.maybeReplaceForCollection((Statement)node, methodInvocation, iterable);
                        }
                    } else if (ASTNodes.isArray(iterable) && ASTNodes.isSameLocalVariable((IBinding)foreachVariable, argument)) {
                        return this.maybeReplaceForArray((Statement)node, iterable, methodInvocation);
                    }
                }
                return true;
            }

            public boolean visit(ForStatement node) {
                Name loopVariable;
                IVariableBinding loopVariableName;
                ForLoops.ForLoopContent loopContent = ForLoops.iterateOverContainer(node);
                MethodInvocation methodInvocation = ASTNodes.asExpression(node.getBody(), MethodInvocation.class);
                if (loopContent != null && loopContent.getLoopVariable() != null && methodInvocation != null && methodInvocation.arguments().size() == 1 && this.getVariableUseCount(loopVariableName = (IVariableBinding)(loopVariable = loopContent.getLoopVariable()).resolveBinding(), node.getBody()) == 1 && (loopContent.isLoopingForward() || methodInvocation.resolveMethodBinding() != null && ASTNodes.hasType(methodInvocation.resolveMethodBinding().getDeclaringClass(), Set.class.getCanonicalName()))) {
                    Expression addArg0 = (Expression)methodInvocation.arguments().get(0);
                    switch (loopContent.getContainerType()) {
                        case COLLECTION: {
                            MethodInvocation getMI = ASTNodes.as(addArg0, MethodInvocation.class);
                            if (getMI == null || getMI.arguments().size() != 1 || !this.isSameVariable(loopContent, getMI)) break;
                            return this.maybeReplaceForCollection((Statement)node, methodInvocation, getMI.getExpression());
                        }
                        case ARRAY: {
                            ArrayAccess arrayAccess = ASTNodes.as(addArg0, ArrayAccess.class);
                            if (!this.isSameVariable(loopContent, arrayAccess)) break;
                            return this.maybeReplaceForArray((Statement)node, loopContent.getContainerVariable(), methodInvocation);
                        }
                    }
                }
                return true;
            }

            private boolean maybeReplaceForArray(Statement node, Expression iterable, MethodInvocation addMethod) {
                IMethodBinding methodBinding = addMethod.resolveMethodBinding();
                if (methodBinding != null && addMethod.getExpression() != null && !ASTNodes.is(addMethod.getExpression(), ThisExpression.class) && ASTNodes.usesGivenSignature(addMethod, Collection.class.getCanonicalName(), "add", Object.class.getCanonicalName()) && this.areTypeCompatible(methodBinding.getDeclaringClass(), iterable.resolveTypeBinding())) {
                    rewriteOperations.add(new AddOrRemoveAllForArrayOperation(node, addMethod.getExpression(), iterable));
                    return false;
                }
                return true;
            }

            private int getVariableUseCount(IVariableBinding variableBinding, Statement toVisit) {
                if (variableBinding != null) {
                    VarDefinitionsUsesVisitor variableUseVisitor = new VarDefinitionsUsesVisitor(variableBinding, (ASTNode)toVisit, true);
                    return variableUseVisitor.getReads().size();
                }
                return 0;
            }

            private boolean isSameVariable(ForLoops.ForLoopContent loopContent, ArrayAccess arrayAccess) {
                return arrayAccess != null && ASTNodes.isSameVariable((ASTNode)arrayAccess.getArray(), (ASTNode)loopContent.getContainerVariable()) && ASTNodes.isSameLocalVariable(arrayAccess.getIndex(), (Expression)loopContent.getLoopVariable());
            }

            private boolean areTypeCompatible(ITypeBinding colTypeBinding, ITypeBinding arrayTypeBinding) {
                if (arrayTypeBinding != null && colTypeBinding != null) {
                    ITypeBinding jucTypeBinding = ASTNodes.findImplementedType(colTypeBinding, Collection.class.getCanonicalName());
                    if (jucTypeBinding.isRawType()) {
                        return true;
                    }
                    ITypeBinding componentType = arrayTypeBinding.getComponentType();
                    ITypeBinding colTypeArgument = jucTypeBinding.getTypeArguments()[0];
                    return componentType.isSubTypeCompatible(colTypeArgument);
                }
                return false;
            }

            private boolean maybeReplaceForCollection(Statement node, MethodInvocation addOrRemoveMethod, Expression data) {
                if (addOrRemoveMethod.getExpression() == null || ASTNodes.is(addOrRemoveMethod.getExpression(), ThisExpression.class)) {
                    return true;
                }
                if (ASTNodes.usesGivenSignature(addOrRemoveMethod, Collection.class.getCanonicalName(), "add", Object.class.getCanonicalName())) {
                    rewriteOperations.add(new AddAllForCollectionOperation(node, addOrRemoveMethod.getExpression(), data));
                    return false;
                }
                return true;
            }

            private boolean isSameVariable(ForLoops.ForLoopContent loopContent, MethodInvocation getMI) {
                Expression methodExpression = getMI.getExpression();
                return (methodExpression instanceof Name || methodExpression instanceof FieldAccess || methodExpression instanceof SuperFieldAccess) && ASTNodes.usesGivenSignature(getMI, List.class.getCanonicalName(), "get", Integer.TYPE.getSimpleName()) && ASTNodes.isSameLocalVariable((Expression)getMI.arguments().get(0), (Expression)loopContent.getLoopVariable()) && ASTNodes.isSameVariable((ASTNode)loopContent.getContainerVariable(), (ASTNode)methodExpression);
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.AddAllCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class AddAllForCollectionOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final Statement toReplace;
        private final Expression affectedCollection;
        private final Expression addedData;

        public AddAllForCollectionOperation(Statement toReplace, Expression affectedCollection, Expression addedData) {
            this.toReplace = toReplace;
            this.affectedCollection = affectedCollection;
            this.addedData = addedData;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.AddAllCleanup_description, cuRewrite);
            MethodInvocation newMethod = ast.newMethodInvocation();
            newMethod.setExpression(ASTNodes.createMoveTarget(rewrite, this.affectedCollection));
            newMethod.setName(ast.newSimpleName("addAll"));
            newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.addedData)));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.toReplace, (ASTNode)ast.newExpressionStatement((Expression)newMethod), group);
        }
    }

    private static class AddOrRemoveAllForArrayOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final Statement toReplace;
        private final Expression affectedCollection;
        private final Expression addedData;

        public AddOrRemoveAllForArrayOperation(Statement toReplace, Expression affectedCollection, Expression addedData) {
            this.toReplace = toReplace;
            this.affectedCollection = affectedCollection;
            this.addedData = addedData;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.AddAllCleanup_description, cuRewrite);
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            if (this.affectedCollection.resolveTypeBinding() != null && this.affectedCollection.resolveTypeBinding().isRawType()) {
                String arraysNameText = importRewrite.addImport(Arrays.class.getCanonicalName());
                MethodInvocation asListMethod = ast.newMethodInvocation();
                asListMethod.setExpression((Expression)ASTNodeFactory.newName(ast, arraysNameText));
                asListMethod.setName(ast.newSimpleName("asList"));
                asListMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.addedData)));
                MethodInvocation addAllMethod = ast.newMethodInvocation();
                addAllMethod.setExpression(ASTNodes.createMoveTarget(rewrite, this.affectedCollection));
                addAllMethod.setName(ast.newSimpleName("addAll"));
                addAllMethod.arguments().add(asListMethod);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.toReplace, (ASTNode)ast.newExpressionStatement((Expression)addAllMethod), group);
            } else {
                String collectionsNameText = importRewrite.addImport(Collections.class.getCanonicalName());
                MethodInvocation newMethod = ast.newMethodInvocation();
                newMethod.setExpression((Expression)ASTNodeFactory.newName(ast, collectionsNameText));
                newMethod.setName(ast.newSimpleName("addAll"));
                newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.affectedCollection)));
                newMethod.arguments().add(ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.addedData)));
                ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)newMethod);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.toReplace, (ASTNode)expressionStatement, group);
            }
        }
    }
}

