/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer.handler;

import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.ScalaTestSuiteSelection;
import ch.epfl.scala.bsp4j.ScalaTestSuites;
import ch.epfl.scala.bsp4j.TestParams;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import com.microsoft.gradle.bs.importer.ImporterPlugin;
import com.microsoft.gradle.bs.importer.Utils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class GradleDelegateCommandHandler
implements IDelegateCommandHandler {
    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        switch (commandId) {
            case "java.gradle.delegateTest": {
                String projectName = (String)arguments.get(0);
                Map tests = (Map)JSONUtility.toModel((Object)arguments.get(1), Map.class);
                IProject project = ProjectUtils.getProject((String)projectName);
                if (project == null) {
                    throw new IllegalArgumentException("Project not found: " + projectName);
                }
                if (!Utils.isGradleBuildServerProject(project)) {
                    throw new IllegalArgumentException("Project is not a Gradle build server project: " + projectName);
                }
                IPath rootPath = ProjectUtils.findBelongedWorkspaceRoot((IPath)project.getLocation());
                BuildServerConnection buildServerConnection = ImporterPlugin.getBuildServerConnection(rootPath, false);
                if (buildServerConnection == null) {
                    throw new IllegalStateException("Build server connection not found for project: " + projectName);
                }
                List<BuildTarget> targets = Utils.getBuildTargetsByProjectUri(buildServerConnection, project.getLocationURI());
                List btIds = targets.stream().filter(bt -> bt.getTags().contains("integration-test") || bt.getTags().contains("test")).map(BuildTarget::getId).collect(Collectors.toList());
                if (btIds.isEmpty()) {
                    throw new IllegalStateException("Invalid number of build targets: " + btIds.size());
                }
                if (btIds.size() > 1) {
                    btIds = btIds.subList(0, 1);
                }
                TestParams testParams = new TestParams(btIds);
                testParams.setDataKind("scala-test-suites-selection");
                testParams.setArguments(this.getArguments(arguments));
                LinkedList<ScalaTestSuiteSelection> testSelections = new LinkedList<ScalaTestSuiteSelection>();
                for (Map.Entry entry : tests.entrySet()) {
                    ScalaTestSuiteSelection testSelection = new ScalaTestSuiteSelection((String)entry.getKey(), (List)entry.getValue());
                    testSelections.add(testSelection);
                }
                ScalaTestSuites scalaTestSuites = new ScalaTestSuites(testSelections, this.getJvmOptions(arguments), this.getEnvVarPairs(arguments));
                testParams.setData((Object)scalaTestSuites);
                buildServerConnection.buildTargetTest(testParams);
                return null;
            }
        }
        throw new UnsupportedOperationException("The command: " + commandId + "is not supported.");
    }

    private List<String> getArguments(List<Object> arguments) {
        if (arguments.size() < 3) {
            return Collections.emptyList();
        }
        return (List)arguments.get(2);
    }

    private List<String> getJvmOptions(List<Object> arguments) {
        if (arguments.size() < 4) {
            return Collections.emptyList();
        }
        return (List)arguments.get(3);
    }

    private List<String> getEnvVarPairs(List<Object> arguments) {
        if (arguments.size() < 5 || arguments.get(4) == null) {
            return Collections.emptyList();
        }
        Map envVars = (Map)JSONUtility.toModel((Object)arguments.get(4), Map.class);
        return envVars.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList());
    }
}

