/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer.jpms;

import com.microsoft.gradle.bs.importer.jpms.JpmsArgType;
import com.microsoft.gradle.bs.importer.jpms.JpmsArgValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JpmsArguments {
    private Map<String, Set<String>> addExports = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> addOpens = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> addReads = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> patchModule = new HashMap<String, Set<String>>();

    public void addJpmsArgument(JpmsArgType type, JpmsArgValue value) {
        switch (type) {
            case ADD_EXPORTS: {
                this.append(this.addExports, value.getModule(), value.getValue());
                break;
            }
            case ADD_OPENS: {
                this.append(this.addOpens, value.getModule(), value.getValue());
                break;
            }
            case ADD_READS: {
                this.append(this.addReads, value.getModule(), value.getValue());
                break;
            }
            case PATCH_MODULE: {
                this.append(this.patchModule, value.getModule(), value.getValue());
                break;
            }
        }
    }

    public Map<String, Set<String>> getGroupedArgumentsByType(JpmsArgType type) {
        switch (type) {
            case ADD_EXPORTS: {
                return this.addExports;
            }
            case ADD_OPENS: {
                return this.addOpens;
            }
            case ADD_READS: {
                return this.addReads;
            }
            case PATCH_MODULE: {
                return this.patchModule;
            }
        }
        return Collections.emptyMap();
    }

    public boolean isEmpty() {
        return this.addExports.isEmpty() && this.addOpens.isEmpty() && this.addReads.isEmpty() && this.patchModule.isEmpty();
    }

    private void append(Map<String, Set<String>> map, String module, String value) {
        if (StringUtils.isNotBlank((CharSequence)module) && StringUtils.isNotBlank((CharSequence)value)) {
            map.computeIfAbsent(module.trim(), k -> new LinkedHashSet()).add(value.trim());
        }
    }
}

