/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;

public class DOMPatternLocator
extends PatternLocator {
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int INACCURATE_MATCH = 1;
    public static final int POSSIBLE_MATCH = 2;
    public static final int ACCURATE_MATCH = 3;
    public static final int ERASURE_MATCH = 4;

    public DOMPatternLocator(SearchPattern pattern) {
        super(pattern);
    }

    public int match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(Expression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(FieldDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(VariableDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(MemberValuePair node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(MethodInvocation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    protected int match(ModuleDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(FieldAccess node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(AbstractTypeDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(TypeParameter node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return 0;
    }

    public int resolveLevel(ASTNode node, MatchLocator locator) {
        return 0;
    }

    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        return 0;
    }

    protected String getQualifiedSourceName(ITypeBinding binding) {
        ITypeBinding type;
        if (binding == null) {
            return null;
        }
        ITypeBinding iTypeBinding = type = binding.isArray() ? binding.getComponentType() : binding;
        if (type.isLocal()) {
            return DOMPatternLocator.qualifiedSourceName(type.getDeclaringClass()) + ".1." + binding.getName();
        }
        if (type.isMember()) {
            return DOMPatternLocator.qualifiedSourceName(type.getDeclaringClass()) + "." + binding.getName();
        }
        return binding.getName();
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, ITypeBinding binding) {
        char[] qualifiedPattern = this.getQualifiedPattern(simpleNamePattern, qualificationPattern);
        int level = this.resolveLevelForType(qualifiedPattern, binding);
        if (level == 3 || binding == null) {
            return level;
        }
        ITypeBinding type = binding.isArray() ? binding.getComponentType() : binding;
        char[] sourceName = null;
        if (type.isMember() || type.isLocal()) {
            sourceName = qualificationPattern != null ? this.getQualifiedSourceName(binding).toCharArray() : binding.getQualifiedName().toCharArray();
        } else if (qualificationPattern == null) {
            sourceName = this.getQualifiedSourceName(binding).toCharArray();
        }
        if (sourceName == null) {
            return 0;
        }
        return this.resolveLevelForTypeSourceName(qualifiedPattern, sourceName, type);
    }

    public static String qualifiedSourceName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding.isLocal()) {
            return binding.isMember() ? DOMPatternLocator.qualifiedSourceName(binding.getDeclaringClass()) + "." + binding.getName() : DOMPatternLocator.qualifiedSourceName(binding.getDeclaringClass()) + ".1." + binding.getName();
        }
        return binding.getQualifiedName();
    }

    private Name getBaseTypeName(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simp = (SimpleType)type;
            return simp.getName();
        }
        if (type instanceof QualifiedType) {
            QualifiedType qn = (QualifiedType)type;
            return qn.getName();
        }
        if (type instanceof ArrayType) {
            ArrayType arr = (ArrayType)type;
            return this.getBaseTypeName(arr.getElementType());
        }
        return null;
    }

    protected boolean matchesTypeReference(char[] pattern, Type type, boolean isVarargs) {
        int dimensions;
        Object simpleName;
        if (pattern == null) {
            return true;
        }
        if (type == null) {
            return true;
        }
        Name name = this.getBaseTypeName(type);
        if (name instanceof SimpleName) {
            SimpleName simple = (SimpleName)name;
            v0 = simple.getIdentifier();
        } else if (name instanceof QualifiedName) {
            QualifiedName qName = (QualifiedName)name;
            v0 = qName.getName().getIdentifier();
        } else if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            v0 = primitive.getPrimitiveTypeCode().toString();
        } else {
            v0 = simpleName = null;
        }
        if (simpleName == null) {
            return true;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            v1 = arrayType.dimensions().size();
        } else {
            v1 = dimensions = 0;
        }
        if (isVarargs) {
            ++dimensions;
        }
        for (int i = 0; i < dimensions; ++i) {
            simpleName = (String)simpleName + "[]";
        }
        return this.matchesName(pattern, ((String)simpleName).toCharArray());
    }

    protected boolean matchesTypeReference(char[] pattern, Type type) {
        return this.matchesTypeReference(pattern, type, false);
    }

    protected int resolveLevelForTypeSourceName(char[] qualifiedPattern, char[] sourceName, ITypeBinding type) {
        switch (this.matchMode) {
            case 1: {
                if (!CharOperation.prefixEquals((char[])qualifiedPattern, (char[])sourceName, (boolean)this.isCaseSensitive)) break;
                return 3;
            }
            case 128: {
                if (qualifiedPattern.length <= 0 || sourceName.length <= 0 || qualifiedPattern[0] != sourceName[0]) break;
                if (CharOperation.camelCaseMatch((char[])qualifiedPattern, (char[])sourceName, (boolean)false)) {
                    return 3;
                }
                if (this.isCaseSensitive || !CharOperation.prefixEquals((char[])qualifiedPattern, (char[])sourceName, (boolean)false)) break;
                return 3;
            }
            case 256: {
                if (qualifiedPattern.length <= 0 || sourceName.length <= 0 || qualifiedPattern[0] != sourceName[0] || !CharOperation.camelCaseMatch((char[])qualifiedPattern, (char[])sourceName, (boolean)true)) break;
                return 3;
            }
            default: {
                if (type != null && type.isLocal() && CharOperation.prefixEquals((char[])qualifiedPattern, (char[])sourceName, (boolean)this.isCaseSensitive)) {
                    return 3;
                }
                if (!CharOperation.match((char[])qualifiedPattern, (char[])sourceName, (boolean)this.isCaseSensitive)) break;
                return 3;
            }
        }
        return 0;
    }

    protected int resolveLevelForType(char[] qualifiedPattern, ITypeBinding type) {
        boolean match1;
        if (qualifiedPattern == null) {
            return 3;
        }
        if (type == null) {
            return 1;
        }
        if (type.isTypeVariable()) {
            return 0;
        }
        if (type instanceof IntersectionTypeBinding18) {
            int result = 0;
            int prev = 0;
            IntersectionTypeBinding18 i18 = (IntersectionTypeBinding18)type;
            for (ReferenceBinding ref : i18.intersectingTypes) {
                result = this.resolveLevelForType(qualifiedPattern, (TypeBinding)ref);
                if (result == 3) {
                    return result;
                }
                if (result == 0 || prev != 0) continue;
                prev = result;
            }
            return prev;
        }
        char[] qualifiedNameFromBinding = type.getQualifiedName().toCharArray();
        if (qualifiedNameFromBinding == null || qualifiedNameFromBinding.length == 0) {
            qualifiedNameFromBinding = type.getName().toCharArray();
        }
        return (match1 = CharOperation.match((char[])qualifiedPattern, (char[])qualifiedNameFromBinding, (boolean)this.isCaseSensitive)) ? 3 : 0;
    }
}

