/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.GenerateToStringOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.ToStringGenerationSettingsCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeGenerationUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionUtility;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GenerateToStringHandler {
    public static final String METHODNAME_TOSTRING = "toString";
    public static final String DEFAULT_TEMPLATE = "${object.className} [${member.name()}=${member.value}, ${otherMembers}]";

    public static CheckToStringResponse checkToStringStatus(CodeActionParams params) {
        return GenerateToStringHandler.checkToStringStatus(params, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckToStringResponse checkToStringStatus(CodeActionParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params, monitor);
        return GenerateToStringHandler.checkToStringStatus(type, monitor);
    }

    public static CheckToStringResponse checkToStringStatus(IType type) {
        return GenerateToStringHandler.checkToStringStatus(type, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CheckToStringResponse checkToStringStatus(IType type, IProgressMonitor monitor) {
        CheckToStringResponse response = new CheckToStringResponse();
        if (type == null) {
            return response;
        }
        try {
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return response;
            }
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                IVariableBinding memberBinding;
                IField member;
                response.type = type.getTypeQualifiedName();
                IVariableBinding[] fields = typeBinding.getDeclaredFields();
                HashMap<IJavaElement, IVariableBinding> fieldsToBindingsMap = new HashMap<IJavaElement, IVariableBinding>();
                HashMap<IJavaElement, IVariableBinding> selectedFieldsToBindingsMap = new HashMap<IJavaElement, IVariableBinding>();
                IVariableBinding[] iVariableBindingArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariableBinding variableBinding = iVariableBindingArray[n2];
                    if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                        fieldsToBindingsMap.put(variableBinding.getJavaElement(), variableBinding);
                        if (!Modifier.isTransient((int)variableBinding.getModifiers())) {
                            selectedFieldsToBindingsMap.put(variableBinding.getJavaElement(), variableBinding);
                        }
                    }
                    ++n2;
                }
                IField[] allFields = type.isRecord() ? type.getRecordComponents() : type.getFields();
                ArrayList<Object> fieldsToBindings = new ArrayList<Object>();
                ArrayList<Object> selectedFieldsToBindings = new ArrayList<Object>();
                IField[] iFieldArray = allFields;
                int n3 = allFields.length;
                int n4 = 0;
                while (n4 < n3) {
                    member = iFieldArray[n4];
                    memberBinding = (IVariableBinding)selectedFieldsToBindingsMap.remove(member);
                    if (memberBinding != null) {
                        selectedFieldsToBindings.add(memberBinding);
                        fieldsToBindingsMap.remove(member);
                    }
                    ++n4;
                }
                iFieldArray = allFields;
                n3 = allFields.length;
                n4 = 0;
                while (n4 < n3) {
                    member = iFieldArray[n4];
                    memberBinding = (IVariableBinding)fieldsToBindingsMap.remove(member);
                    if (memberBinding != null) {
                        fieldsToBindings.add(memberBinding);
                    }
                    ++n4;
                }
                selectedFieldsToBindings.sort(new JdtDomModels.BindingComparator());
                fieldsToBindings.sort(new JdtDomModels.BindingComparator());
                ArrayList<Object> inheritedFieldsToBindings = new ArrayList<Object>();
                ITypeBinding superTypeBinding = typeBinding;
                while ((superTypeBinding = superTypeBinding.getSuperclass()) != null) {
                    IVariableBinding[] iVariableBindingArray2 = superTypeBinding.getDeclaredFields();
                    int memberBinding2 = iVariableBindingArray2.length;
                    int n5 = 0;
                    while (n5 < memberBinding2) {
                        IVariableBinding candidateField = iVariableBindingArray2[n5];
                        if (!(Modifier.isPrivate((int)candidateField.getModifiers()) || Modifier.isStatic((int)candidateField.getModifiers()) || JdtDomModels.contains(fieldsToBindings, candidateField))) {
                            inheritedFieldsToBindings.add(candidateField);
                        }
                        ++n5;
                    }
                }
                inheritedFieldsToBindings.sort(new JdtDomModels.BindingComparator());
                ArrayList<Object> methodsToBindings = new ArrayList<Object>();
                IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
                int n6 = iMethodBindingArray.length;
                int memberBinding2 = 0;
                while (memberBinding2 < n6) {
                    IMethodBinding candidateMethod = iMethodBindingArray[memberBinding2];
                    if (!(Modifier.isStatic((int)candidateMethod.getModifiers()) || candidateMethod.getParameterTypes().length != 0 || "void".equals(candidateMethod.getReturnType().getName()) || METHODNAME_TOSTRING.equals(candidateMethod.getName()) || "clone".equals(candidateMethod.getName()))) {
                        methodsToBindings.add(candidateMethod);
                    }
                    ++memberBinding2;
                }
                methodsToBindings.sort(new JdtDomModels.BindingComparator());
                superTypeBinding = typeBinding;
                ArrayList<Object> inheritedMethodsToBindings = new ArrayList<Object>();
                while ((superTypeBinding = superTypeBinding.getSuperclass()) != null) {
                    IMethodBinding[] iMethodBindingArray2 = superTypeBinding.getDeclaredMethods();
                    int n7 = iMethodBindingArray2.length;
                    n6 = 0;
                    while (n6 < n7) {
                        IMethodBinding candidateMethod = iMethodBindingArray2[n6];
                        if (!(Modifier.isPrivate((int)candidateMethod.getModifiers()) || Modifier.isStatic((int)candidateMethod.getModifiers()) || candidateMethod.getParameterTypes().length != 0 || "void".equals(candidateMethod.getReturnType().getName()) || JdtDomModels.contains(methodsToBindings, candidateMethod) || "clone".equals(candidateMethod.getName()))) {
                            inheritedMethodsToBindings.add(candidateMethod);
                        }
                        ++n6;
                    }
                }
                inheritedMethodsToBindings.sort(new JdtDomModels.BindingComparator());
                LinkedList<JdtDomModels.LspVariableBinding> result = new LinkedList<JdtDomModels.LspVariableBinding>();
                result.addAll(selectedFieldsToBindings.stream().map(f -> new JdtDomModels.LspVariableBinding((IVariableBinding)f, true)).toList());
                result.addAll(fieldsToBindings.stream().map(f -> new JdtDomModels.LspVariableBinding((IVariableBinding)f)).toList());
                result.addAll(inheritedFieldsToBindings.stream().map(f -> new JdtDomModels.LspVariableBinding((IVariableBinding)f)).toList());
                result.addAll(methodsToBindings.stream().map(f -> new JdtDomModels.LspVariableBinding((IMethodBinding)f)).toList());
                result.addAll(inheritedMethodsToBindings.stream().map(f -> new JdtDomModels.LspVariableBinding((IMethodBinding)f)).toList());
                response.fields = result.toArray(new JdtDomModels.LspVariableBinding[0]);
                response.exists = CodeActionUtility.hasMethod(type, METHODNAME_TOSTRING, new Class[0]);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to check toString status", e);
        }
        return response;
    }

    public static WorkspaceEdit generateToString(GenerateToStringParams params, IProgressMonitor monitor) {
        IType type = SourceAssistProcessor.getSelectionType(params.context, monitor);
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        Range range = params.context.getRange();
        ASTNode declarationNode = null;
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
        if (astRoot != null && range != null) {
            ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)DiagnosticsHelper.getStartOffset(type.getCompilationUnit(), range), (int)DiagnosticsHelper.getLength(type.getCompilationUnit(), range));
            declarationNode = SourceAssistProcessor.getTypeDeclarationNode(node);
        }
        IJavaElement insertPosition = declarationNode != null ? CodeGenerationUtils.findInsertElement(type, null) : CodeGenerationUtils.findInsertElement(type, range);
        TextEdit edit = GenerateToStringHandler.generateToString(type, params.fields, insertPosition, monitor);
        return edit == null ? null : SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
    }

    public static TextEdit generateToString(IType type, JdtDomModels.LspVariableBinding[] fields, IJavaElement insertPosition, IProgressMonitor monitor) {
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        ToStringGenerationSettingsCore settings = new ToStringGenerationSettingsCore();
        settings.overrideAnnotation = true;
        settings.createComments = preferences.isCodeGenerationTemplateGenerateComments();
        settings.useBlocks = preferences.isCodeGenerationTemplateUseBlocks();
        settings.stringFormatTemplate = StringUtils.isBlank((CharSequence)preferences.getGenerateToStringTemplate()) ? DEFAULT_TEMPLATE : preferences.getGenerateToStringTemplate();
        settings.toStringStyle = GenerateToStringHandler.getToStringStyle(preferences.getGenerateToStringCodeStyle());
        settings.skipNulls = preferences.isGenerateToStringSkipNullValues();
        settings.customArrayToString = preferences.isGenerateToStringListArrayContents();
        settings.limitElements = preferences.getGenerateToStringLimitElements() > 0;
        settings.limitValue = Math.max(preferences.getGenerateToStringLimitElements(), 0);
        settings.customBuilderSettings = new ToStringGenerationSettingsCore.CustomBuilderSettings();
        return GenerateToStringHandler.generateToString(type, fields, settings, insertPosition, monitor);
    }

    public static TextEdit generateToString(IType type, JdtDomModels.LspVariableBinding[] fields, ToStringGenerationSettingsCore settings, IJavaElement insertPosition, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        block5: {
            if (type == null) {
                return null;
            }
            astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)type.getCompilationUnit(), CoreASTProvider.WAIT_YES, monitor);
            if (astRoot != null) break block5;
            return null;
        }
        try {
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
            if (typeBinding != null) {
                Object[] selectedFields = JdtDomModels.convertToBindings(typeBinding, fields);
                GenerateToStringOperation operation = GenerateToStringOperation.createOperation((ITypeBinding)typeBinding, (Object[])selectedFields, (CompilationUnit)astRoot, (IJavaElement)insertPosition, (ToStringGenerationSettingsCore)settings, (boolean)false, (boolean)false);
                operation.run(null);
                return operation.getResultingEdit();
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to generate toString()", e);
        }
        return null;
    }

    private static int getToStringStyle(String codeStyle) {
        if (StringUtils.isBlank((CharSequence)codeStyle)) {
            return 0;
        }
        switch (codeStyle) {
            case "STRING_CONCATENATION": {
                return 0;
            }
            case "STRING_BUILDER": {
                return 1;
            }
            case "STRING_BUILDER_CHAINED": {
                return 2;
            }
            case "STRING_FORMAT": {
                return 3;
            }
        }
        return 0;
    }

    public static class CheckToStringResponse {
        public String type;
        public JdtDomModels.LspVariableBinding[] fields;
        public boolean exists;
    }

    public static class GenerateToStringParams {
        public CodeActionParams context;
        public JdtDomModels.LspVariableBinding[] fields;
    }
}

