# What's new in Visual Studio Code Java?

*April 2019*

Welcome to the April 2019 release of Extension Pack for Java. This document aims to recap the features, bug fixes around Java language support in between releases. Here are some of the key highlights:

- [Java 12](#java-12-supported) supported
- [More Source Actions](#more-source-actions) added to Java language server
- [Logical Structure](#display-logical-structure-of-collections) of collections displayed by debugger
- [Debugging Maven Goals](#debug-maven-goals) made easy
- [JDK Acquisition Guide](#jdk-acquisition-guide) to guide you download and install Java Development Kit

The release notes are arranged in the following sections related to VS Code Java focus areas. Here are some further updates:

- [Code Editing](#code-editing)
- [Debugging](#debugging)
- [Maven](#maven)
- [Troubleshooting](#troubleshooting)

## Code Editing

### Java 12 Supported

Java 12 is supported now. To use the experimental language features like the new `switch` statement, add the following settings to `pom.xml`:

```xml
<build>
    <plugins>
        <plugin>
            <groupId>org.apache.maven.plugins</groupId>
            <artifactId>maven-compiler-plugin</artifactId>
            <version>3.8.0</version>
            <configuration>
                <source>12</source>
                <compilerArgs>--enable-preview</compilerArgs>
            </configuration>
        </plugin>
    </plugins>
</build>
```

### Better Performance

With the latest release of [Language Server for Java by Red Hat](https://marketplace.visualstudio.com/items?itemName=redhat.java), the performance of dealing with larger amount of source files is improved. When you have many open files in your editor, the language server is more responsive.

### More Source Actions

#### Resolve Ambiguous Imports

To deal with ambiguous imports, you now have a dropdown list to pick the right one. The code line with the unresolved type is also presented to you to help you decide.

![Resolve Ambiguous Imports](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.organize.imports.gif)

#### Override/Implement Methods

With the new source action, all the candidates are presented to you with a checklist. Then you can decide what to override or implement.

![Override/Implement Methods](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.implement.methods.gif)

#### Generate `hashCode()` & `equals()`

Now `hashCode()` & `equals()` can be generated with default implementations. All the non-static member variables are listed, and you can customize the generated code using the check list.

There are two options for you to customize the generated code:

- If you use Java 7+, you can set `java.codeGeneration.hashCodeEquals.useJava7Objects` to `true` to generate shorter code which calls `Objects.hash` and `Objects.equals`.
- You can also set `java.codeGeneration.hashCodeEquals.useInstanceof` to `true` to use `instanceOf` operator to check the object types instead of calling `Object.getClass()`.

![Generate `hashCode()` & `equals()`](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.hashcode.equals.gif)

#### Generate `toString()`

`toString()` can also be generated with the new source action. Customization is also possible with the check list of all the member variables.

![Generate `toString()`](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.generate.tostring.gif)

#### Convert to Static Imports

Last but not least, you can now convert static functions calls to static imports.

![Convert to Static Imports](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.convert.static.import.gif)

### Folding Range

Folding range allows you to fold or unfold code snippet to better view the source code.

![Folding Range](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.folding.range.gif)

## Debugging

### Display Logical Structure of Collections

The debugger is now showing the logical structure of lists and maps, instead of the physical layout of the collections.

If you prefer the physical layout view, you can go back by setting `java.debug.settings.showLogicalStructure` to `false`.

![Logical Structure of Collections](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.debug.logical.structure.gif)

### Highlight Exceptions in Editor

Exceptions are now highlighted with extra info in the editor window. Before that, you need to hover on the exception to see details. Now the most important info is presented to you right at where it occurs.

![Highlight Excpetions in Editor](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/java.debug.exception.view.gif)

### Go to Definition by Clicking Stack Trace in Debug Console

When there's an exception, you can click on the stack trace to see the definition of the function calls.

![Go to Definition by Clicking Stack Trace in Debug Console](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/debug.gtd.stack.trace.gif)

## Maven

Maven extensions released some interesting features and improvements to improve the productivity.

### Debug Maven Goals

To debug Maven goals, just right click on a goal and start debugging. The Maven extension will call the Java debugger with the right parameters. This is handy and super time-saving.

![Debug Maven Goals](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/maven.debug.goals.gif)

### New Command to Add a Dependency

Maven extension released a new command `Maven: Add a Dependency` (or `maven.project.addDependency`) to help add a new dependency to `pom.xml`. The process is interactive.

![Maven Add Dependency](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/maven.add.dependency.gif)

## Troubleshooting

### JDK Acquisition Guide

If you are experiencing the problem of setting up the JDK, we've got you covered. The JDK Acquisition Guide follows the same logic used by the Java language server to check for a JDK installation on your machine. When the check fails, the guide will automatically show and recommend a JDK distribution that is compatible with your OS and CPU architecture.

![JDK Acquisition Guide](https://github.com/Microsoft/vscode-java-pack/raw/main/release-notes/v0.7.0/jdk.acquisition.guide.gif)

## Thank You

Here are more changes and bug fixes. Kudos to all the contributors!

- [@snjeza](https://github.com/snjeza)
    - [Langauge Server] Download java sources lazily [eclipse/eclipse.jdt.ls#979](https://github.com/eclipse/eclipse.jdt.ls/issues/979)
    - [Langauge Server] Optimize compilation unit computations [eclipse/eclipse.jdt.ls#980](https://github.com/eclipse/eclipse.jdt.ls/issues/980)
    - [Langauge Server] Optimize server initialization [eclipse/eclipse.jdt.ls#981](https://github.com/eclipse/eclipse.jdt.ls/issues/981)
- [@testforstephen](https://github.com/testforstephen)
    - [Debugger] Debug console does not autocomplete when a .class file is open [Microsoft/vscode-java-debug#535](https://github.com/Microsoft/vscode-java-debug/issues/535)
    - [Debugger] Auto shorten the command line for the case "CreateProcess error=206, The filename or extension is too long" [Microsoft/vscode-java-debug#110](https://github.com/Microsoft/vscode-java-debug/issues/110)
- [@jdneo](https://github.com/jdneo)
    - [Test Runner] Output encoding issue of the Test Runner [Microsoft/vscode-java-test#632](https://github.com/Microsoft/vscode-java-test/issues/632)
    - [Test Runner] Stop honor the deprecated 'launch.test.json' [Microsoft/vscode-java-test#650](https://github.com/Microsoft/vscode-java-test/issues/650)
    - [Test Runner] Properly resolve classpath for invisible projects [Microsoft/vscode-java-test#348](https://github.com/Microsoft/vscode-java-test/issues/348#issuecomment-480687978)

## Happy Coding!
