/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;

public class JavaUtils {
    private JavaUtils() {
    }

    public static String getJavaVersionFromFile(File jdkFile) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(jdkFile.toPath().resolve("bin").resolve("java").toString(), "-version");
        return JavaUtils.getJavaVersionFromFile(processBuilder);
    }

    static String getJavaVersionFromFile(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.redirectErrorStream(true).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String versionLine = reader.readLine();
        while (versionLine != null && !versionLine.contains("version")) {
            versionLine = reader.readLine();
        }
        process.destroy();
        if (versionLine != null) {
            versionLine = versionLine.split("\"")[1];
        }
        return versionLine;
    }

    public static boolean isCompatible(@Nonnull String javaVersion, @Nonnull String oldestJavaVersion, @Nonnull String latestJavaVersion) throws IllegalArgumentException {
        Runtime.Version versionToCheck = Runtime.Version.parse(javaVersion);
        Runtime.Version oldestVersion = Runtime.Version.parse(oldestJavaVersion);
        Runtime.Version latestVersion = Runtime.Version.parse(latestJavaVersion);
        return versionToCheck.feature() >= oldestVersion.feature() && versionToCheck.feature() <= latestVersion.feature();
    }
}

