/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.tm4e.core.model.TMModel;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.model.DocumentHelper;
import org.eclipse.tm4e.ui.model.ITMDocumentModel;

public final class TMDocumentModel
extends TMModel
implements ITMDocumentModel,
IDocumentListener {
    private final IDocument document;
    private int endLineIndexOfRemovedText = -1;

    public TMDocumentModel(IDocument document) {
        super(document.getNumberOfLines());
        this.document = document;
        document.addDocumentListener((IDocumentListener)this);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        try {
            switch (DocumentHelper.getEventType(event)) {
                case REPLACE: 
                case REMOVE: {
                    this.endLineIndexOfRemovedText = DocumentHelper.getEndLineIndexOfRemovedText(event);
                }
            }
        }
        catch (BadLocationException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
        }
    }

    public void documentChanged(DocumentEvent event) {
        try {
            int startLineIndex = DocumentHelper.getStartLineIndex(event);
            switch (DocumentHelper.getEventType(event)) {
                case INSERT: {
                    int endLineIndexOfAddedText = DocumentHelper.getEndLineIndexOfAddedText(event);
                    boolean isFullLineInsert = DocumentHelper.getStartLineCharIndex(event) == 0 && event.getText().endsWith("\n");
                    int linesAdded = (isFullLineInsert ? 0 : 1) + (endLineIndexOfAddedText - startLineIndex);
                    this.onLinesReplaced(startLineIndex, isFullLineInsert ? 0 : 1, linesAdded);
                    break;
                }
                case REMOVE: {
                    this.onLinesReplaced(startLineIndex, 1 + (this.endLineIndexOfRemovedText - startLineIndex), 1);
                    break;
                }
                case REPLACE: {
                    int endLineIndexOfAddedText = DocumentHelper.getEndLineIndexOfAddedText(event);
                    boolean isFullLineInsert = DocumentHelper.getStartLineCharIndex(event) == 0 && event.getText().endsWith("\n");
                    this.onLinesReplaced(startLineIndex, (isFullLineInsert ? 0 : 1) + (this.endLineIndexOfRemovedText - startLineIndex), (isFullLineInsert ? 0 : 1) + (endLineIndexOfAddedText - startLineIndex));
                }
            }
        }
        catch (BadLocationException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
        }
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    public String getLineText(int lineIndex) throws Exception {
        return DocumentHelper.getLineText(this.document, lineIndex, false);
    }

    public void dispose() {
        this.document.removeDocumentListener((IDocumentListener)this);
        super.dispose();
    }
}

