/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractUpdateIndexAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!(this.fSelection instanceof IStructuredSelection) && !(this.fSelection instanceof ITextSelection)) {
            return;
        }
        ICElement[] elements = this.getSelectedCElements();
        this.doRun(elements);
    }

    protected void doRun(ICElement[] elements) {
        try {
            CCorePlugin.getIndexManager().update(elements, this.getUpdateOptions());
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    protected abstract int getUpdateOptions();

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public boolean isEnabledFor(ISelection selection) {
        this.selectionChanged(null, selection);
        ICElement[] elements = this.getSelectedCElements();
        return elements.length > 0;
    }

    protected ICElement[] getSelectedCElements() {
        ICProject cproject;
        IProject project;
        ArrayList<Object> tuSelection = new ArrayList<Object>();
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection resources = SelectionConverter.convertSelectionToResources(this.fSelection);
            for (Object o : resources) {
                ICElement celement;
                if (!(o instanceof IResource) || (celement = CCorePlugin.getDefault().getCoreModel().create((IResource)o)) == null) continue;
                tuSelection.add(celement);
            }
        } else if ((this.fSelection == null || this.fSelection instanceof ITextSelection) && (project = EditorUtility.getProjectForActiveEditor()) != null && (cproject = CCorePlugin.getDefault().getCoreModel().create(project)) != null) {
            tuSelection.add(cproject);
        }
        return tuSelection.toArray(new ICElement[tuSelection.size()]);
    }
}

