/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui;

import java.util.List;
import org.eclipse.cdt.lsp.editor.ConfigurationVisibility;
import org.eclipse.cdt.lsp.editor.EditorMetadata;
import org.eclipse.cdt.lsp.editor.EditorOptions;
import org.eclipse.cdt.lsp.ui.ConfigurationArea;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class EditorConfigurationArea
extends ConfigurationArea<EditorOptions> {
    private final Button prefer;
    private final Button showBanner;
    private ConfigurationVisibility visibility = (ConfigurationVisibility)PlatformUI.getWorkbench().getService(ConfigurationVisibility.class);

    public EditorConfigurationArea(Composite parent, boolean isProjectScope) {
        super(1);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(this.columns).create());
        if (this.visibility.showPreferLsp(isProjectScope)) {
            this.prefer = this.createButton(EditorMetadata.Predefined.preferLspEditor, composite, 32, 0);
            this.showBanner = !isProjectScope ? this.createButton(EditorMetadata.Predefined.showTryLspBanner, composite, 32, 0) : null;
        } else {
            this.prefer = null;
            this.showBanner = null;
        }
    }

    @Override
    public void store(IEclipsePreferences prefs) {
        OsgiPreferenceMetadataStore store = new OsgiPreferenceMetadataStore(prefs);
        this.buttons.entrySet().forEach(e -> store.save((Object)((Button)e.getValue()).getSelection(), (PreferenceMetadata)e.getKey()));
    }

    @Override
    public void load(EditorOptions options, boolean enable) {
        if (this.prefer != null) {
            this.prefer.setSelection(options.preferLspEditor());
            this.prefer.setEnabled(enable);
        }
        if (this.showBanner != null) {
            this.showBanner.setSelection(options.showTryLspBanner());
            this.showBanner.setEnabled(enable);
        }
    }

    @Override
    public List<String> getPreferenceKeys() {
        return List.of(EditorMetadata.Predefined.preferLspEditor.identifer(), EditorMetadata.Predefined.showTryLspBanner.identifer());
    }

    @Override
    public void applyData(Object data) {
        if (data == "HIGHLIGHT_PREFER_LSP") {
            this.prefer.setFocus();
        }
    }
}

