/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.IProxyCache;

public class MapProxyCache
implements IProxyCache {
    private HashMap<String, CDataProxy> fMap;

    private HashMap<String, CDataProxy> getMap(boolean create) {
        if (this.fMap == null && create) {
            this.fMap = new HashMap();
        }
        return this.fMap;
    }

    @Override
    public CDataProxy[] getCachedProxies() {
        HashMap<String, CDataProxy> map = this.getMap(false);
        if (map != null) {
            Collection c = map.values();
            return c.toArray(new CDataProxy[c.size()]);
        }
        return new CDataProxy[0];
    }

    @Override
    public CDataProxy getCachedProxy(String id) {
        HashMap<String, CDataProxy> map = this.getMap(false);
        if (map != null) {
            return (CDataProxy)map.get(id);
        }
        return null;
    }

    @Override
    public void removeCachedProxy(String id) {
        HashMap<String, CDataProxy> map = this.getMap(false);
        if (map != null) {
            map.remove(id);
        }
    }

    @Override
    public void clear() {
        this.fMap.clear();
    }

    @Override
    public void addCachedProxy(CDataProxy proxy) {
        this.getMap(true).put(proxy.getId(), proxy);
    }

    @Override
    public Map<String, CDataProxy> getCachedProxiesMap() {
        return (Map)this.getMap(true).clone();
    }

    @Override
    public CDataProxy getCachedProxy(CDataObject data) {
        return this.getCachedProxy(data.getId());
    }

    @Override
    public void removeCachedProxy(CDataProxy proxy) {
        this.removeCachedProxy(proxy.getId());
    }

    public void reuseProxies(List<CDataObject> dataList, Map<String, CDataProxy> freeProxyMap) {
    }
}

