/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.util.concurrent.ExecutionException;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.dnd.IShellDropHandler;

public abstract class AbstractModuleDropHandler
implements IShellDropHandler {
    protected Object loadModule(IScriptEngine scriptEngine, String moduleID, boolean force) {
        if (force || this.getLoadedModule(scriptEngine, moduleID) == null) {
            if (ModuleHelper.resolveModuleName((String)moduleID) != null) {
                try {
                    ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
                    String functionCall = codeFactory.createFunctionCall(EnvironmentModule.class.getMethod("loadModule", String.class, Boolean.TYPE), new Object[]{moduleID, false});
                    return scriptEngine.execute((Object)functionCall).get();
                }
                catch (NoSuchMethodException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)"Method loadModule() not found", (Throwable)e);
                }
                catch (SecurityException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)"Method loadModule() not accessible", (Throwable)e);
                }
                catch (ExecutionException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)"Method loadModule() failed to execute script code", (Throwable)e);
                }
            } else {
                Logger.error((String)"org.eclipse.ease.ui", (String)("Module \"" + moduleID + "\" cannot be found"));
            }
        }
        return this.getLoadedModule(scriptEngine, moduleID);
    }

    private Object getLoadedModule(IScriptEngine scriptEngine, String moduleID) {
        IEnvironment environment = IEnvironment.getEnvironment((IScriptEngine)scriptEngine);
        if (environment != null) {
            return environment.getModule(moduleID);
        }
        return null;
    }
}

