/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import java.io.File;
import java.io.IOException;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class SymParser {
    private static final Pattern REGEX = Pattern.compile("^([a-fA-F\\d]+)\\s+([a-fA-F\\d]*)\\s*([ABbCcDdGgiNPpRrSsTtUuVvWw\\-\\?])\\s*(.*)$");
    private final NavigableMap<Long, Symbol> fMap = new TreeMap<Long, Symbol>();

    public static SymParser parse(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (LineIterator iter = FileUtils.lineIterator((File)file);){
            SymParser sp = new SymParser();
            while (iter.hasNext()) {
                String line = iter.next();
                if (line.startsWith("#")) continue;
                Matcher match = REGEX.matcher(line);
                if (!match.matches()) {
                    throw new IllegalArgumentException("Symbol Parser: invalid line: " + line);
                }
                long range = Long.parseUnsignedLong(match.group(1), 16);
                char c = match.group(3).charAt(0);
                String name = match.groupCount() < 4 ? "Anonymous" : match.group(4);
                Symbol sym = new Symbol(c, name);
                sp.fMap.put(range, sym);
            }
            return sp;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public NavigableMap<Long, Symbol> getMap() {
        return this.fMap;
    }

    public static final class Symbol {
        private final char fType;
        private final String fName;

        private Symbol(char c, String name) {
            this.fType = c;
            this.fName = name;
        }

        public char getType() {
            return this.fType;
        }

        public String getName() {
            return this.fName;
        }
    }
}

