/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.Objects;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.ui.IEditorInput;

public class SourceLookupResult
implements ISourceLookupResult {
    private final Object fArtifact;
    private final Object fSourceElement;
    private final String fEditorId;
    private final IEditorInput fEditorInput;

    public SourceLookupResult(Object artifact, Object sourceElement, String editorId, IEditorInput editorInput) {
        this.fArtifact = artifact;
        this.fSourceElement = sourceElement;
        this.fEditorId = editorId;
        this.fEditorInput = editorInput;
    }

    @Override
    public Object getArtifact() {
        return this.fArtifact;
    }

    @Override
    public Object getSourceElement() {
        return this.fSourceElement;
    }

    @Override
    public String getEditorId() {
        return this.fEditorId;
    }

    @Override
    public IEditorInput getEditorInput() {
        return this.fEditorInput;
    }

    public int hashCode() {
        return Objects.hash(this.fArtifact, this.fEditorId, this.fEditorInput, this.fSourceElement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourceLookupResult)) {
            return false;
        }
        SourceLookupResult other = (SourceLookupResult)obj;
        return Objects.equals(this.fEditorId, other.fEditorId) && Objects.equals(this.fArtifact, other.fArtifact) && Objects.equals(this.fEditorInput, other.fEditorInput) && Objects.equals(this.fSourceElement, other.fSourceElement);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SourceLookupResult [");
        if (this.fEditorId != null) {
            builder.append("editorId=");
            builder.append(this.fEditorId);
            builder.append(", ");
        }
        if (this.fEditorInput != null) {
            builder.append("editorInput=");
            builder.append(this.fEditorInput);
            builder.append(", ");
        }
        if (this.fArtifact != null) {
            builder.append("artifact=");
            builder.append(this.fArtifact);
            builder.append(", ");
        }
        if (this.fSourceElement != null) {
            builder.append("sourceElement=");
            builder.append(this.fSourceElement);
        }
        builder.append("]");
        return builder.toString();
    }
}

