/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;

public class CommentFormatFix
implements IFix {
    private final IJavaScriptUnit fCompilationUnit;
    private final TextChange fChange;

    public static IFix createCleanUp(IJavaScriptUnit unit, boolean singleLine, boolean multiLine, boolean javaDoc, HashMap preferences) throws CoreException {
        if (!(singleLine || multiLine || javaDoc)) {
            return null;
        }
        String content = unit.getBuffer().getContents();
        Document document = new Document(content);
        List edits = CommentFormatFix.format((IDocument)document, singleLine, multiLine, javaDoc, preferences);
        if (edits.size() == 0) {
            return null;
        }
        MultiTextEdit resultEdit = new MultiTextEdit();
        resultEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
        CompilationUnitChange change = new CompilationUnitChange(MultiFixMessages.CommentFormatFix_description, unit);
        change.setEdit((TextEdit)resultEdit);
        String label = MultiFixMessages.CommentFormatFix_description;
        CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
        group.addTextEdit((TextEdit)resultEdit);
        change.addTextEditGroup((TextEditGroup)group);
        return new CommentFormatFix((TextChange)change, unit);
    }

    static String format(String input, boolean singleLine, boolean multiLine, boolean javaDoc) {
        if (!(singleLine || multiLine || javaDoc)) {
            return input;
        }
        Document document = new Document(input);
        HashMap preferences = new HashMap(JavaScriptCore.getOptions());
        List edits = CommentFormatFix.format((IDocument)document, singleLine, multiLine, javaDoc, preferences);
        if (edits.size() == 0) {
            return input;
        }
        MultiTextEdit resultEdit = new MultiTextEdit();
        resultEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
        try {
            resultEdit.apply((IDocument)document);
        }
        catch (MalformedTreeException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        return document.get();
    }

    private static List format(IDocument document, boolean singleLine, boolean multiLine, boolean javaDoc, HashMap preferences) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        JavaScriptPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner(document, "___java_partitioning");
        String content = document.get();
        CommentFormattingStrategy formattingStrategy = new CommentFormattingStrategy();
        CommentFormattingContext context = new CommentFormattingContext();
        context.setProperty("formatting.context.preferences", preferences);
        context.setProperty("formatting.context.document", Boolean.TRUE);
        context.setProperty("formatting.context.medium", document);
        try {
            try {
                ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)"___java_partitioning", (int)0, (int)document.getLength(), (boolean)false);
                int i = 0;
                while (i < regions.length) {
                    TextEdit edit;
                    ITypedRegion region = regions[i];
                    if (singleLine && region.getType().equals("__java_singleline_comment")) {
                        edit = CommentFormatFix.format(region, (IFormattingContext)context, formattingStrategy, content);
                        if (edit != null) {
                            edits.add(edit);
                        }
                    } else if (multiLine && region.getType().equals("__java_multiline_comment")) {
                        edit = CommentFormatFix.format(region, (IFormattingContext)context, formattingStrategy, content);
                        if (edit != null) {
                            edits.add(edit);
                        }
                    } else if (javaDoc && region.getType().equals("__java_javadoc") && (edit = CommentFormatFix.format(region, (IFormattingContext)context, formattingStrategy, content)) != null) {
                        edits.add(edit);
                    }
                    ++i;
                }
            }
            catch (BadLocationException e) {
                JavaScriptPlugin.log(e);
                context.dispose();
            }
        }
        finally {
            context.dispose();
        }
        return edits;
    }

    private static TextEdit format(ITypedRegion region, IFormattingContext context, CommentFormattingStrategy formattingStrategy, String content) {
        TypedPosition typedPosition = new TypedPosition(region.getOffset(), region.getLength(), region.getType());
        context.setProperty((Object)"formatting.context.partition", (Object)typedPosition);
        formattingStrategy.formatterStarts(context);
        TextEdit edit = formattingStrategy.calculateTextEdit();
        formattingStrategy.formatterStops();
        if (edit == null) {
            return null;
        }
        if (!edit.hasChildren()) {
            return null;
        }
        TextEdit[] children = edit.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof ReplaceEdit)) {
                return edit;
            }
            ++i;
        }
        Document doc = new Document(content);
        try {
            edit.copy().apply((IDocument)doc, 0);
            if (content.equals(doc.get())) {
                return null;
            }
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
        return edit;
    }

    public CommentFormatFix(TextChange change, IJavaScriptUnit compilationUnit) {
        this.fChange = change;
        this.fCompilationUnit = compilationUnit;
    }

    @Override
    public TextChange createChange() throws CoreException {
        return this.fChange;
    }

    @Override
    public IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    @Override
    public String getDescription() {
        return MultiFixMessages.CommentFormatFix_description;
    }

    @Override
    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

