/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.colors;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.ui.themes.ColorUtil;

public class ColorSetting {
    private @Nullable RGB fForegroundRGB;
    private @Nullable RGB fBackgroundRGB;
    private @NonNull RGB fTickColorRGB;
    private @Nullable Color fForegroundColor;
    private @Nullable Color fBackgroundColor;
    private @Nullable Color fDimmedForegroundColor;
    private @Nullable Color fDimmedBackgroundColor;
    private @NonNull Color fTickColor;
    private @Nullable ITmfFilterTreeNode fFilter;

    public ColorSetting(@Nullable RGB foreground, @Nullable RGB background, @Nullable RGB tickColorRGB, @Nullable ITmfFilterTreeNode filter) {
        this.fForegroundRGB = foreground;
        this.fBackgroundRGB = background;
        this.fTickColorRGB = tickColorRGB != null ? tickColorRGB : (RGB)NonNullUtils.checkNotNull((Object)Display.getDefault().getSystemColor(24).getRGB());
        this.fFilter = filter;
        Display display = Display.getDefault();
        this.fForegroundColor = this.fForegroundRGB != null ? new Color((Device)display, this.fForegroundRGB) : null;
        this.fBackgroundColor = this.fBackgroundRGB != null ? new Color((Device)display, this.fBackgroundRGB) : null;
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)(this.fForegroundRGB != null ? this.fForegroundRGB : display.getSystemColor(24).getRGB()), (RGB)(this.fBackgroundRGB != null ? this.fBackgroundRGB : display.getSystemColor(25).getRGB())));
        this.fDimmedBackgroundColor = this.fBackgroundRGB == null ? null : new Color((Device)display, ColorUtil.blend((RGB)this.fBackgroundRGB, (RGB)display.getSystemColor(25).getRGB()));
        this.fTickColor = new Color((Device)display, this.fTickColorRGB);
    }

    public void dispose() {
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
        }
        if (this.fDimmedForegroundColor != null) {
            this.fDimmedForegroundColor.dispose();
        }
        if (this.fDimmedBackgroundColor != null) {
            this.fDimmedBackgroundColor.dispose();
        }
        this.fTickColor.dispose();
    }

    public @Nullable RGB getForegroundRGB() {
        return this.fForegroundRGB;
    }

    public void setForegroundRGB(@Nullable RGB foreground) {
        this.fForegroundRGB = foreground;
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
        }
        if (this.fDimmedForegroundColor != null) {
            this.fDimmedForegroundColor.dispose();
        }
        Display display = Display.getDefault();
        this.fForegroundColor = this.fForegroundRGB != null ? new Color((Device)display, this.fForegroundRGB) : null;
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)(this.fForegroundRGB != null ? this.fForegroundRGB : display.getSystemColor(24).getRGB()), (RGB)(this.fBackgroundRGB != null ? this.fBackgroundRGB : display.getSystemColor(25).getRGB())));
    }

    public @Nullable RGB getBackgroundRGB() {
        return this.fBackgroundRGB;
    }

    public void setBackgroundRGB(@Nullable RGB background) {
        this.fBackgroundRGB = background;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
        }
        if (this.fDimmedBackgroundColor != null) {
            this.fDimmedBackgroundColor.dispose();
        }
        if (this.fDimmedForegroundColor != null) {
            this.fDimmedForegroundColor.dispose();
        }
        Display display = Display.getDefault();
        this.fBackgroundColor = this.fBackgroundRGB != null ? new Color((Device)display, this.fBackgroundRGB) : null;
        this.fDimmedBackgroundColor = this.fBackgroundRGB == null ? null : new Color((Device)display, ColorUtil.blend((RGB)this.fBackgroundRGB, (RGB)display.getSystemColor(25).getRGB()));
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)(this.fForegroundRGB != null ? this.fForegroundRGB : display.getSystemColor(24).getRGB()), (RGB)(this.fBackgroundRGB != null ? this.fBackgroundRGB : display.getSystemColor(25).getRGB())));
    }

    public @NonNull RGB getTickColorRGB() {
        return this.fTickColorRGB;
    }

    public void setTickColorRGB(@NonNull RGB tickColorRGB) {
        this.fTickColorRGB = tickColorRGB;
        this.fTickColor.dispose();
        Display display = Display.getDefault();
        this.fTickColor = new Color((Device)display, this.fTickColorRGB);
    }

    public @Nullable ITmfFilterTreeNode getFilter() {
        return this.fFilter;
    }

    public void setFilter(@Nullable ITmfFilterTreeNode filter) {
        this.fFilter = filter;
    }

    public @Nullable Color getForegroundColor() {
        return this.fForegroundColor;
    }

    public @Nullable Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    public @Nullable Color getDimmedForegroundColor() {
        return this.fDimmedForegroundColor;
    }

    public @Nullable Color getDimmedBackgroundColor() {
        return this.fDimmedBackgroundColor;
    }

    public Color getTickColor() {
        return this.fTickColor;
    }
}

