/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public abstract class JavaScriptRefactoringDescriptor
extends RefactoringDescriptor {
    protected static final String ATTRIBUTE_ELEMENT = "element";
    protected static final String ATTRIBUTE_INPUT = "input";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_REFERENCES = "references";
    protected static final String ATTRIBUTE_SELECTION = "selection";
    protected static final String ATTRIBUTE_VERSION = "version";
    public static final int JAR_MIGRATION = 65536;
    public static final int JAR_REFACTORING = 524288;
    public static final int JAR_SOURCE_ATTACHMENT = 262144;
    protected static final String VALUE_VERSION_1_0 = "1.0";
    protected final Map fArguments;

    protected static String elementToHandle(String project, IJavaScriptElement element) {
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IJavaScriptProject)) {
            String id = element.getJavaScriptProject().getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    protected static IJavaScriptElement handleToElement(String project, String handle) {
        return JavaScriptRefactoringDescriptor.handleToElement(project, handle, true);
    }

    protected static IJavaScriptElement handleToElement(String project, String handle, boolean check) {
        return JavaScriptRefactoringDescriptor.handleToElement(null, project, handle, check);
    }

    protected static IJavaScriptElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IJavaScriptElement element = null;
        element = owner != null ? JavaScriptCore.create((String)handle, (WorkingCopyOwner)owner) : JavaScriptCore.create((String)handle);
        if (element == null && project != null) {
            IJavaScriptProject javaProject = JavaScriptCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaScriptProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? JavaScriptCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : JavaScriptCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (check && element instanceof IFunction) {
            IFunction[] iFunctionArray;
            IFunction method = (IFunction)element;
            if (method.getDeclaringType() != null) {
                iFunctionArray = method.getDeclaringType().findMethods(method);
            } else {
                IFunction[] iFunctionArray2 = new IFunction[1];
                iFunctionArray = iFunctionArray2;
                iFunctionArray2[0] = method.getJavaScriptUnit().getFunction(method.getElementName(), method.getParameterTypes());
            }
            IFunction[] methods = iFunctionArray;
            if (methods != null && methods.length > 0) {
                element = methods[0];
            }
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    protected static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    protected static String resourceToHandle(String project, IResource resource) {
        if (project != null && !"".equals(project)) {
            return resource.getProjectRelativePath().toPortableString();
        }
        return resource.getFullPath().toPortableString();
    }

    protected JavaScriptRefactoringDescriptor(String id) {
        this(id, new HashMap());
    }

    protected JavaScriptRefactoringDescriptor(String id, Map arguments) {
        super(id, null, DescriptorMessages.JavaRefactoringDescriptor_not_available, null, 6);
        this.fArguments = arguments;
        this.fArguments.put(ATTRIBUTE_VERSION, VALUE_VERSION_1_0);
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        this.populateArgumentMap();
        Refactoring refactoring = null;
        String id = this.getID();
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)id);
        if (contribution != null) {
            RefactoringDescriptor descriptor = contribution.createDescriptor(id, this.getProject(), this.getDescription(), this.getComment(), this.fArguments, this.getFlags());
            if (descriptor != null) {
                refactoring = descriptor.createRefactoring(status);
            } else {
                JavaManipulationPlugin.log((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 0, MessageFormat.format(DescriptorMessages.JavaRefactoringDescriptor_no_resulting_descriptor, id), null));
            }
        }
        return refactoring;
    }

    protected Map getArguments() {
        this.populateArgumentMap();
        return new HashMap(this.fArguments);
    }

    protected void populateArgumentMap() {
        Assert.isTrue((!this.validateDescriptor().hasFatalError() ? 1 : 0) != 0, (String)"Validation returns a fatal error status.");
    }

    public void setComment(String comment) {
        super.setComment(comment);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setFlags(int flags) {
        super.setFlags(flags);
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = new RefactoringStatus();
        String description = this.getDescription();
        if (description == null || "".equals(description)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.JavaRefactoringDescriptor_no_description));
        }
        return status;
    }
}

